from django.forms import model_to_dict
from rest_framework import serializers

from ok.approvements import models


class ApprovementSerializer(serializers.ModelSerializer):

    approvers = serializers.SerializerMethodField()

    def get_approvers(self, obj):
        if 'approvers_by_approvement' in self.root.context:
            return self.root.context['approvers_by_approvement'][obj.id]

    class Meta:
        model = models.Approvement
        fields = '__all__'


class ApprovementHistorySerializer(serializers.ModelSerializer):

    event_time = serializers.DateTimeField(source='created')
    approvement = ApprovementSerializer()
    stage = serializers.SerializerMethodField()

    def get_stage(self, obj):
        return model_to_dict(obj.stage) if obj.stage else None

    class Meta:
        model = models.ApprovementHistory
        yt_schema = {
            'id': 'int32',
            'type': 'string',
            'object_id': 'int32',
            'event_time': 'string',
            'event': 'string',
            'user': 'string',
            'status': 'string',
            'resolution': 'string',
            'approvement': 'any',
            'stage': 'any',
            'context': 'any',
        }
        fields = tuple(yt_schema)
