import logging

from django.utils import translation
from django.utils.deprecation import MiddlewareMixin

from ok.core.permissions import is_yauser_authenticated
from ok.utils.context import request_context


logger = logging.getLogger(__name__)


class RequestContextMiddleware(MiddlewareMixin):

    def process_request(self, request):
        request_context.init(request=request)

    def process_response(self, request, response):
        request_context.reset()
        return response


def locale_middleware(get_response):

    def middleware(request):
        lang = 'ru'
        if is_yauser_authenticated(request.yauser):
            lang = request.yauser.language or lang
        translation.activate(lang)
        return get_response(request)

    return middleware
