from ok.utils.attrs import get_attribute


class SynchronizerBase:

    model_class = None
    fields_map = {}

    def iter(self):
        raise NotImplementedError

    def sync(self):
        raise NotImplementedError

    def normalize_remote_item(self, remote_item) -> dict:
        return {
            db_field: get_attribute(remote_item, remote_field, default='')
            for db_field, remote_field in self.fields_map.items()
        }

    def has_anything_changed(self, db_item, normalized_remote_item):
        return any(
            get_attribute(db_item, f) != get_attribute(normalized_remote_item, f)
            for f in self.fields_map
        )
