from django.conf import settings
from django.template import loader
from premailer import Premailer

from .tasks import send_email, push_notification_to_app_task


def notify(transport, template_name, context, **kwargs):
    """
    Шорткат для отправки нотификации куда бы то ни было
    kwargs передаются дальше, как есть.
    Пока отправка только на email.
    """
    transport_method_map = {
        'email': notify_by_email,
        'xiva': push_notification_to_app_task.delay,
    }

    if transport not in transport_method_map:
        raise ValueError('Unexpected transport')

    notify_method = transport_method_map[transport]
    body = loader.render_to_string(template_name, context).strip()
    notify_method(body, **kwargs)


def notify_by_email(body, receiver, subject=None, **kwargs):
    body = Premailer(body, remove_classes=True).transform()
    from_email = '"ok" <{email}>'.format(email=settings.DEFAULT_FROM_EMAIL)

    send_email.delay(
        subject=subject,
        body=body,
        to=[receiver],
        from_email=from_email,
        **kwargs
    )
