# Generated by Django 2.2.5 on 2022-03-28 15:20

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('tracker', '0006_trigger'),
        ('staff', '0002_url_as_pk'),
        ('flows', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Scenario',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('slug', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('status', models.CharField(
                    choices=[
                        ('active', 'scenario.status.active'),
                        ('archived', 'scenario.status.archived'),
                    ],
                    default='active',
                    max_length=32,
                )),
                ('name', models.CharField(max_length=255)),
                ('author', models.CharField(max_length=255)),
                ('approvement_data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict)),
                ('flow', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='flows.Flow')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ScenarioTrackerMacro',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('tracker_id', models.IntegerField()),
                ('scenario', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='tracker_macros', to='scenarios.Scenario')),
                ('tracker_queue', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='scenario_macros', to='tracker.Queue')),
            ],
        ),
        migrations.CreateModel(
            name='ScenarioResponsibleGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='scenario_groups', to='staff.Group')),
                ('scenario', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='scenario_groups', to='scenarios.Scenario')),
            ],
        ),
        migrations.AddField(
            model_name='scenario',
            name='responsible_groups',
            field=models.ManyToManyField(
                blank=True,
                related_name='_scenario_responsible_groups_+',
                through='scenarios.ScenarioResponsibleGroup',
                to='staff.Group',
            ),
        ),
    ]
