# Generated by Django 2.2.27 on 2022-05-16 12:02
from django.db import migrations
from django.db.models import F

from ok.tracker.helpers import get_macro_body


def fill_body(apps, schema_editor):
    ScenarioTrackerMacro = apps.get_model('scenarios', 'ScenarioTrackerMacro')
    macros = list(
        ScenarioTrackerMacro.objects
        .annotate(scenario_slug=F('scenario__slug'))
        .filter(
            body__isnull=True,
            scenario__isnull=False,
        )
    )
    for macro in macros:
        macro.body = get_macro_body({'scenario': macro.scenario_slug})
    ScenarioTrackerMacro.objects.bulk_update(macros, ['body'], 100)


class Migration(migrations.Migration):

    dependencies = [
        ('scenarios', '0003_macro_source_etc'),
    ]

    operations = [
        migrations.RunPython(fill_body, migrations.RunPython.noop),
    ]
