# Generated by Django 2.2.27 on 2022-06-08 12:43

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('tracker', '0006_trigger'),
        ('scenarios', '0004_macro_fill_body'),
    ]

    operations = [
        migrations.AddField(
            model_name='scenariotrackermacro',
            name='created',
            field=model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created'),
        ),
        migrations.AddField(
            model_name='scenariotrackermacro',
            name='modified',
            field=model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified'),
        ),
        migrations.CreateModel(
            name='ScenarioTrackerTrigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255)),
                ('tracker_id', models.IntegerField()),
                ('order', models.CharField(max_length=64)),
                ('actions', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('conditions', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('version', models.IntegerField()),
                ('source', models.CharField(choices=[('ok', 'ok'), ('tracker', 'tracker')], default='ok', help_text='Откуда появился триггер (через какую систему создан)', max_length=32)),
                ('is_active', models.BooleanField(default=True)),
                ('is_compatible', models.BooleanField(default=True, help_text='Совместим ли на данный момент триггер со сценариями в ОКе')),
                ('scenario', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='tracker_triggers', to='scenarios.Scenario')),
                ('tracker_queue', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='scenario_triggers', to='tracker.Queue')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
