from django.contrib import admin, messages

from ok.staff.models import Group, GroupMembership
from ok.staff.tasks import sync_groups_task


@admin.register(Group)
class GroupAdmin(admin.ModelAdmin):

    actions = (
        'sync',
    )

    search_fields = (
        'url',
        'name_ru',
        'name_en',
    )

    list_display = (
        'url',
        'name_ru',
        'name_en',
        'type',
        'is_deleted',
    )

    list_editable = (
        'is_deleted',
    )

    list_filter = (
        'type',
        'is_deleted',
    )

    def sync(self, request, queryset):
        sync_groups_task.delay()
        messages.success(request, 'Синхронизация начата')


@admin.register(GroupMembership)
class GroupMembershipAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'group',
    )

    search_fields = (
        'login',
        'group__url',
    )

    list_display = (
        'id',
        'login',
        'group',
    )

    list_select_related = (
        'group',
    )
