from django.db import models

from ok.staff.choices import GROUP_TYPES
from ok.staff.managers import GroupManager


class Group(models.Model):

    objects = GroupManager()

    url = models.CharField(max_length=255, primary_key=True)
    staff_id = models.IntegerField(null=True, blank=True)
    is_deleted = models.BooleanField(default=False)
    name_ru = models.CharField(max_length=255, null=True)
    name_en = models.CharField(max_length=255, null=True)
    type = models.CharField(max_length=32, choices=GROUP_TYPES, null=True, blank=True)

    def __str__(self):
        return f'Group {self.url}'


class GroupMembership(models.Model):

    login = models.CharField(max_length=64, db_index=True)
    group = models.ForeignKey(
        to=Group,
        on_delete=models.CASCADE,
        related_name='memberships',
    )

    def __str__(self):
        return f'GroupMembership {self.id}: @{self.login}, {self.group_id}'

    class Meta:
        unique_together = ('login', 'group')
