from django.contrib import admin
from django.template.defaultfilters import truncatechars

from ok.tracker.models import CheckedComment, Queue


@admin.register(CheckedComment)
class CheckedCommentAdmin(admin.ModelAdmin):

    search_fields = (
        '=comment_id',
        '=approvement__id',
    )

    list_display = (
        'comment_id',
        'approvement',
        'author',
        'short_text',
        'comment_created_at',
        'is_ok',
    )

    list_select_related = (
        'approvement',
    )

    raw_id_fields = (
        'approvement',
    )

    @staticmethod
    def short_text(obj):
        return truncatechars(obj.text, 50)


@admin.register(Queue)
class QueueAdmin(admin.ModelAdmin):

    list_display = (
        'name',
        'has_triggers',
        'allow_externals',
    )
