import re

from django.conf import settings
from startrek_client import Startrek

from ok.utils.context import request_context
from ok.utils.tvm import get_service_ticket


QUEUE_KEY_RE = re.compile(r'^(?P<queue>[A-Z]{1,15})$')
ISSUE_KEY_RE = re.compile(r'^(?P<queue>[a-zA-Z]{1,15})-\d+$')


def get_tracker_client(**kwargs):
    return Startrek(
        useragent='serviceok',
        base_url=settings.TRACKER_API_URL,
        verify=settings.ROOT_CA_BUNDLE,
        **kwargs,
    )


def get_user_tracker_client():
    return get_tracker_client(
        service_ticket=get_service_ticket(settings.TVM_TRACKER_CLIENT_ID),
        user_ticket=request_context.user_ticket,
    )


client = get_tracker_client(token=settings.OK_ROBOT_TOKEN)

# Creating st connection without accessing private parameters if impossible
# due to desing of startrack lib (the reffer eachother by private attribute)
st_connection = client._connection
