import re

from urllib.parse import urlunsplit, urlencode

from django.conf import settings

from ok.tracker.choices import TRACKER_VARIABLES

TRACKER_MACRO_MAIN_QUERY = (
    f'_embedded=1'
    f'&author={TRACKER_VARIABLES.current_user_login}'
    f'&object_id={TRACKER_VARIABLES.issue_key}'
    f'&uid={TRACKER_VARIABLES.current_datetime_iso}'
)


def get_macro_iframe_url(params: dict):
    query = TRACKER_MACRO_MAIN_QUERY
    if params:
        extra_query = urlencode(params)
        query = f'{query}&{extra_query}'
    return urlunsplit(('https', settings.OK_HOST, '/tracker', query, ''))


def get_macro_body(params: dict):
    url = get_macro_iframe_url(params)
    return f'{{{{=<% %>=}}}}{{{{iframe src="{url}" frameborder=0 width=100% height=400px}}}}'


def fetch_ok_iframe_tracker_url(text):
    """
    Извлекает из коммента наш iframe-url.
    Если извлечь не удалось, отдает None.
    """
    text = text or ''
    rgx = re.compile(
        rf'{{iframe src="(?P<url>{settings.OK_URL}tracker.*?)".*?}}',
        flags=re.UNICODE | re.DOTALL,
    )
    match = rgx.search(text)
    return match.groupdict().get('url') if match else None


def replace_url_in_macro_body(text, new_url):
    """
    Внутри нашего iframe заменяет url
    """
    text = text or ''
    url_rgx = rf'{settings.OK_URL}tracker.*?'
    rgx = re.compile(
        rf'(?P<iframe_begin>{{iframe src=")(?P<url>{url_rgx})(?P<iframe_end>".*?}})',
        flags=re.UNICODE | re.DOTALL,
    )
    return rgx.sub(rf'\g<iframe_begin>{new_url}\g<iframe_end>', text)
