from django.utils.functional import cached_property
from startrek_client import collections

from ok.tracker.base import client


macros = client._get_collection(collections.Macros)


def create_macro(queue, name, body=None, **kwargs):
    params = {'queue': queue}
    return macros.create(params, name=name, body=body, **kwargs)


def update_macro(key, queue, **kwargs):
    macro = macros.get(key, queue=queue)
    return macro.update(**kwargs)


def delete_macro(key, queue):
    macro = macros.get(key, queue=queue)
    return macro.delete()


# Временный класс для получения макроса или текста ошибки в ScenarioAdmin
class RemoteTrackerMacro:

    def __init__(self, tracker_id: int, queue_name: str):
        self.tracker_id = tracker_id
        self.queue_name = queue_name
        self.exception = None

    @cached_property
    def macro(self):
        try:
            return macros.get(self.tracker_id, queue=self.queue_name)
        except Exception as exc:
            self.exception = exc
        return None
