from django.db import models

from ok.approvements.models import Approvement


class CheckedComment(models.Model):
    approvement = models.ForeignKey(
        Approvement,
        related_name='checked_comments',
        on_delete=models.SET_NULL,
        null=True,
    )
    author = models.CharField(max_length=255)
    text = models.TextField()
    comment_id = models.IntegerField(unique=True)
    comment_created_at = models.DateTimeField()
    is_ok = models.BooleanField(default=False)

    class Meta:
        db_table = 'comments_checkedcomment'


class Queue(models.Model):

    name = models.CharField(max_length=15, unique=True)
    has_triggers = models.NullBooleanField()
    allow_externals = models.NullBooleanField()

    def __str__(self):
        return self.name


class Trigger(models.Model):
    queue = models.ForeignKey(
        Queue,
        related_name='triggers',
        on_delete=models.SET_NULL,
        null=True
    )
    tracker_id = models.IntegerField(db_index=True)
