from django.contrib import admin, messages
from django.contrib.auth.admin import UserAdmin as DjangoUserAdmin
from django.utils.translation import ugettext_lazy as _

from ok.core.admin import fieldset
from ok.staff.tasks import sync_users_task
from ok.users.models import User


@admin.register(User)
class UserAdmin(DjangoUserAdmin):

    actions = (
        'sync',
    )

    fieldsets = (
        fieldset(fields=(
            'username',
            'staff_id',
            'uid',
        )),
        fieldset(_('Personal info'), (
            'first_name',
            'last_name',
            'first_name_en',
            'last_name_en',
            'email',
            'language',
            'affiliation',
            'is_dismissed',
        )),
        fieldset(_('Permissions'), (
            'is_active',
            'is_staff',
            'is_superuser',
            'groups',
            'user_permissions',
        )),
        fieldset(_('Important dates'), (
            'last_login',
            'date_joined',
        )),
    )

    def sync(self, request, queryset):
        sync_users_task.delay()
        messages.success(request, 'Синхронизация начата')
