from ids.registry import registry
from ids.services.abc.repositories import ABCRepository
from ids.services.abc.connector import ABCConnector
from django.conf import settings
from ids.repositories.base import RepositoryBase

ABCConnector.url_patterns['duty'] = u'/api/v4/duty/on_duty/'


@registry.add_simple
class DutyRepository(RepositoryBase):
    connector_cls = ABCConnector

    SERVICE = 'abc'
    RESOURCES = 'duty'

    def getiter_from_service(self, lookup):
        return self.connector.get(resource=self.RESOURCES, params=lookup)


class AbcWorker:
    """
    Class for working with abc service
    """

    def __init__(self):
        self._members_repo = registry.get_repository(
            service='abc',
            resource_type='service_members',
            user_agent='ok',
            oauth_token=settings.ABC_OAUTH_TOKEN,
        )

        self._duty_repo = registry.get_repository(
            service='abc',
            resource_type='duty',
            user_agent='ok',
            oauth_token=settings.ABC_OAUTH_TOKEN,
        )

    def _iter_abc(self, repo, lookup):
        # type: (ABCRepository, Dict) -> Iterable[Dict]
        for item in repo.getiter(lookup=lookup):
            yield item

    def get_users_by_role_id(self, role_id):
        lookup = {
            'role': role_id,
            'fields': 'person.login',
        }

        return list({person['person']['login'] for person in self._iter_abc(self._members_repo, lookup)})

    def get_on_duty_by_service_slug(self, service_slug):
        lookup = {
            'service__slug': service_slug,
            'fields': 'person.login',
        }

        return list({
            person['person']['login'] for person in self._iter_abc(self._duty_repo, lookup) if person['person']
        })


worker = AbcWorker()
