import pytz

from datetime import datetime


TZ_MOSCOW = pytz.timezone('Europe/Moscow')


def get_beginning_of_moscow_day(dt):
    """
    :param dt: aware datetime
    :return: Start of moscow datetime
    """
    assert dt.tzinfo is not None
    current_dt = dt.astimezone(TZ_MOSCOW)
    return current_dt.replace(hour=0, minute=0, second=0, microsecond=0)


def parse_aware_datetime(str_datetime, format):
    """
    Приводит строковое представление даты к datetime в UTC таймзоне
    """
    assert '%z' not in format and '%Z' not in format
    return pytz.utc.localize(datetime.strptime(str_datetime, format))
