import ylock
from functools import wraps
from typing import Callable


from django.conf import settings


lock_manager = ylock.create_manager(**settings.YLOCK)


class CantTakeLockException(Exception):
    pass


def lock_by_approvement(func: Callable):
    """
    Can be used only in ApprovementController for actions

    Calls function after lock taken or lock=False flag got.
    In case if we can't take lock raise http 408
    """
    @wraps(func)
    def locked_func(*args, **kwargs):
        lock = kwargs.pop('lock', True)
        if lock:
            lock_name = str(args[0].instance.uuid)
            lock = lock_manager.lock(lock_name, timeout=settings.YLOCK_DEFAULT_TIMEOUT, block=True)
            with lock as is_locked_successfully:
                if is_locked_successfully:
                    return func(*args, **kwargs)
                raise CantTakeLockException()
        return func(*args, **kwargs)

    return locked_func
