from logging import getLogger

from ids.connector import http
from ids.exceptions import BackendError


logger = getLogger(__name__)


class WikiConnector(http.HttpConnector):
    url_patterns = dict(html='/v6/html')

    @property
    def config(self):
        return {
            'protocol': 'https',
            'host': 'wf.yandex-team.ru',
        }


def format_markup(text, connector=None):
    connector = connector or WikiConnector(user_agent='ok', retries=3)
    return connector.post(
        resource='html',
        data=dict(text=text, cfg='intranet_email'),
        headers={'Content-Type': 'application/x-www-form-urlencoded'}
    ).text


def format_markup_safe(text, connector=None, default=''):
    try:
        result = format_markup(text, connector)
    except BackendError as exc:
        logger.warning('Failed to query wiki formatter with text %s', text, exc)
        result = default

    return result
