from typing import Dict, List

# Ручка для просмотра контекста пропозлы:
#     https://staff.yandex-team.ru/proposal-api/_debug_flow_context/606f4676d978bb5378a531f7
# Пример пропозлы с созанием новых подразделений и пересадкой в них людей:
#     https://staff.yandex-team.ru/proposal-api/_debug_flow_context/604f3b6b30cab06fcbcf5a6b

# Заглушки для функций реализованных на стороне флоу:
approver = []


def add_approver(x):
    approver.append(x)
    print(x)


def drop_approvement():
    raise Exception('Drop')


def hr_partners(dep_url):
    if dep_url == 'outstaff_2289_dep08975_dep54476':
        return ['hrbp123']
    if dep_url == 'outstaff_2289_dep08975':
        return ['hrbp123']
    if dep_url == 'outstaff_9036_2140_3583_dep77726':
        return ['hrbp-zen']
    if dep_url == 'outstaff_2289_dep08975_dep54476_int':
        return ['hrbp123-int']



params = {"ticket_type": "personal", "ticket_person": "alkhabarovsk", "department_actions": [], "person_actions": [
    {
        "login": "alkhabarovsk", "sections": ["department"],
        "department": {"changing_duties": False, "department": "as_5706_8139_dep95924", "fake_department": "",
                       "from_maternity_leave": False, "service_groups": ["svc_directsupport", "svc_yacntrct"],
                       "vacancy_url": "", "with_budget": True}, "action_id": "act_18014",
        "comment": "\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430 \u0432 \u0434\u0440\u0443\u0433\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443",
        "__department_chain__": ["outstaff", "outstaff_3210", "outstaff_3210_2341", "as", "as_dep08316", "as_5706",
                                 "as_5706_8139", "as_5706_8139_dep89345", "as_5706_8139_dep56656"]},
    {
        "login": "ykopalova", "sections": ["department"],
        "department": {"changing_duties": False, "department": "as_5706_8139_dep95924", "fake_department": "",
                       "from_maternity_leave": False, "service_groups": ["svc_directsupport", "svc_yacntrct"],
                       "vacancy_url": "", "with_budget": True}, "action_id": "act_03955",
        "comment": "\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430 \u0432 \u0434\u0440\u0443\u0433\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443",
        "__department_chain__": ["outstaff", "outstaff_3210", "outstaff_3210_2341", "as", "as_dep08316", "as_5706",
                                 "as_5706_8139", "as_5706_8139_dep89345", "as_5706_8139_dep56656"]},
    {
        "login": "mnem0syne", "sections": ["department"],
        "department": {"changing_duties": False, "department": "as_5706_8139_dep95924", "fake_department": "",
                       "from_maternity_leave": False, "service_groups": ["svc_directsupport", "svc_yacntrct"],
                       "vacancy_url": "", "with_budget": True}, "action_id": "act_56355",
        "comment": "\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430 \u0432 \u0434\u0440\u0443\u0433\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443",
        "__department_chain__": ["outstaff", "outstaff_3210", "outstaff_3210_2341", "as", "as_dep08316", "as_5706",
                                 "as_5706_8139", "as_5706_8139_dep89345", "as_5706_8139_dep56656"]},
], "vacancy_actions": [], "headcount_actions": []}


_departments_data = {
    # тут сидит imp
    'outstaff_2289_dep08975_dep54476': {
        'all_parents': [
            '5',
            '4',
            'outstaff_2289_dep08975',
            'outstaff_2289',
            'outstaff',
        ],
        'heads': ['head', 'head1', 'head2'],
        'hr_partners': ['hrbp1', 'hrbp2'],
    },
    # сюда переводим imp в test_WITH_BUDGET_IN_BG_case
    'outstaff_2289_dep08975': {
        'all_parents': [
            '5',
            '4',
            'outstaff_2289_dep08975',
            'outstaff_2289',
            'outstaff',
        ],
        'heads': ['head1', 'head2'],
        'hr_partners': ['hrbp-only1'],
    },
    'outstaff_9036_2140_3583_dep77726': {
        'all_parents': [
            'outstaff_9036_2140_3583',
            'outstaff_9036_2140',
            'outstaff_9036_dep74652',
            'outstaff_9036',
            'outstaff',
        ],
        'heads': ['zen_head', 'zen_head1', 'zen_head2'],
        'hr_partners': ['zen_hrbp1', 'zen_hrbp2'],
    },
    'outstaff_2289_dep08975_dep54476_int': {
        'all_parents': [
            'outstaff_2289_dep08975',
            'outstaff_2289',
            'outstaff',
        ],
        'heads': ['head', 'head1', 'head2'],
        'hr_partners': ['hrbp1-int', 'hrbp2-int'],
    },
    'outstaff_2289_8265_dep35947_dep61539_dep25035_dep30374': {
        'all_parents': [
            'outstaff_2289_8265_dep35947_dep61539_dep25035',
            'outstaff_2289_8265_dep35947_dep61539',
            'outstaff_2289',
            'outstaff',
        ],
        'heads': ['zen_head', 'zen_head1', 'zen_head2'],
        'hr_partners': ['zen_hrbp2'],
    },
    'yandex_edu_analytics_bo_1991':{
        'all_parents': [
            'yandex_edu_analytics_bo',
            'yandex_edu_analytics',
            'yandex'
        ],
        'heads': ['ya_head', 'ya_head1', 'ya_head2'],
        'hr_partners': ['ya_hrbp'],
    },
    'outstaff_3210_2341_9150_dep82813':{
        'all_parents': [
            'outstaff_3210_2341_9150',
            'outstaff_3210_2341',
            'outstaff_3210',
            'outstaff'
            ],
        'heads': ['s_out_head', 's_out_head1', 's_out_head2'],
        'hr_partners': ['s_out_hrbp'],
    },
    'as_7861_dep61649_dep62744':{
        'all_parents': [
            'outstaff_3210_2341_9150',
            'as_7861_dep61649',
            'as_7861',
            'as',
            'outstaff_3210_2341',
            'outstaff_3210',
            'outstaff',
        ],
    }
}


class Department:

    def __init__(self, department_url):
        self.url = department_url

    def __eq__(self, other) -> bool:
        return isinstance(other, flow_api.Department) and self.url == other.url

    def __hash__(self) -> int:
        return hash(self.url)

    def __str__(self) -> str:
        return self.url

    def __repr__(self) -> str:
        return f'Department<{self.url}>'

    @property
    def parent(self) -> 'Department' or None:
        return Department(_departments_data[self.url]['all_parents'][0])

    def get_ancestors(self, with_self=True) -> List['Department']:
        parents = [flow_api.Department(url) for url in _departments_data[self.url]['all_parents']]
        if with_self:
            parents.insert(0, self)
        return parents

    @property
    def head(self) -> 'Person':
        return flow_api.Person(_departments_data[self.url]['heads'][0])

    @property
    def hr_partners(self) -> List['Person']:
        return [flow_api.Person(login) for login in _departments_data[self.url]['hr_partners']]

    @property
    def heads_chain(self) -> List['Person']:
        return [flow_api.Person(login) for login in _departments_data[self.url]['heads']]


_persons_data = {
    'imp': {
        'department': 'outstaff_2289_dep08975_dep54476',
        #'hr_partners': ['hrbp', 'hrbpppp'],
        'is_external': True,
        'is_intern': False,
    },
    'intern': {
            'department': 'outstaff_2289_dep08975_dep54476_int',
            'hr_partners': ['hrbp123-intfff', 'hrbp1-intfff'],
            'is_external': False,
            'is_intern': True,
        },
    'artkuz01': {
            'department': 'outstaff_2289_8265_dep35947_dep61539_dep25035_dep30374',
            'hr_partners': ['hrbp-artkuz01'],
            'is_external': False,
            'is_intern': True,
        },
    'portal_kpb': {
            'department': 'outstaff_3210_2341_9150_dep82813',
            'hr_partners': ['hrbp-portal_kpb'],
            'is_external': True,
            'is_intern': False,
        },
    'dddenisova': {
            'department': 'as_7861_dep61649_dep62744',
            'hr_partners': ['hrbp-media_kpb'],
            'is_external': True,
            'is_intern': False,
    }
}


class Person:

    def __init__(self, login):
        self.login = login

    def __eq__(self, other) -> bool:
        return isinstance(other, flow_api.Person) and self.login == other.login

    def __hash__(self) -> int:
        return hash(self.login)

    def __str__(self) -> str:
        return self.login

    def __repr__(self) -> str:
        return f'Person<{self.login}>'

    @property
    def department(self) -> Department:
        return flow_api.Department(_persons_data[self.login]['department'])

    @property
    def hr_partners(self) -> List['Person']:
        return [flow_api.Person(login) for login in _persons_data[self.login]['hr_partners']]

    @property
    def head(self) -> 'Person':
        return self.department.head

    @property
    def heads_chain(self) -> List['Person']:
        return self.department.heads_chain

    @property
    def department_chain(self) -> List[Department]:
        return self.department.get_ancestors()

    @property
    def is_external(self) -> bool:
        return _persons_data[self.login]['is_external']

    @property
    def is_intern(self) -> bool:
        return _persons_data[self.login]['is_intern']


class flow_api:
    Department = Department
    Person = Person


del Person
del Department
