def get_dev_mode():
    try:
        import os
    except ImportError:
        return False
    return bool(int(os.getenv('DEV_MODE', 0)))


DEV_MODE = get_dev_mode()
if DEV_MODE:
    from unittest.mock import MagicMock
    flow_api = MagicMock()
    department_url = MagicMock()
    hr_partners = MagicMock()
    department_chain_of_heads = MagicMock()
    add_approver = MagicMock()
    set_approvement_field = MagicMock()


def main(params):
    global add_approver
    approvers = []
    _add_approver = add_approver

    # FIXME: Временный костыль.
    #  Если у нас добавлен хоть один approver, нам не нужно делать auto_approve совсем
    def add_approver(approver):
        approvers.append(approver)
        _add_approver(approver)

    def set_auto_approve():
        if approvers:
            return
        set_approvement_field(
            approve_if_no_approvers=True,
            text='Командировка утверждена автоматически',
        )

    person_login = params['author_login']
    person = flow_api.Person(person_login)
    person_department = department_url(person)
    hrs = hr_partners(params['author_login'])
    city_to = params.get('city_to')
    country_to = params.get('country_to')
    purposeone = params.get('purposeone')
    purposetwo = params.get('purposetwo')
    topmanagers = params.get('topmanagers')
    author = params.get('author')
    is_automatic_approval = params.get('is_automatic_approval')
    heads = department_chain_of_heads(url=person_department, until_chief_login='tigran', include_until=False, skip_duplicates=True)
    ex_hrs = ('antonfedorov', 'julpetrova', 'elenmikh13', 'zimaleto','palitra', 'nastiamel', 'ekaterina-phl', 'v-klimenko', 'svetzoval', 'a-knyazeva', 'tashak', 'mblanche', 'alexandrabok', 'oserdyuk', 'alekseevajv', 'annaaleks', 'lili-na', 'olgash', 'v-gribanova', 'kettu', 'alexmaslyuk', 'khusnetdinova', 'yana-ya', 'anna-ti', 'iraivanova')
    ex_heads = ('dkachmar', 'ratatoskr', 'jpopelysheva', 'styskin', 'daniilsh', 'grishakov', 'nadyag', 'bunina', 'asavinovsky', 'veral', 'demyashkevich', 'liumin')
    replace_hrs = ('lera-no', 'gidwani', 'pantyukhinal', 'yulialashina', 'korobova', 'gurzhiol', 'mariatihonova')
    rus_sng_country = ('Россия', 'Russia', 'Russian federation', 'Азербайджан', 'Azerbaijan', 'Армения', 'Armenia', 'Беларусь', 'Belarus', 'Казахстан', 'Kazakhstan', 'Киргизия', 'Kyrgyzstan', 'Молдавия', 'Moldova', 'Таджикистан', 'Tajikistan', 'Узбекистан', 'Uzbekistan')

    if len(heads) > 0 and heads[0] == person_login:
        heads = heads[1:]

    # Временные исключения + is_automatic_approval передает из trip.yandex-team.ru (true/false) для автоока по целям поездки

    excluded_departments = (
        'as',
        'outstaff_0956',
        'outstaff_3210_2341',
        'outstaff_3210_dep25037',
        'outstaff_8244',
        'yandex_biz_com_sales_mass_divcount_bktcis_5439',
        'yandex_content_dep23951',
        'yandex_dep79124_dep69863',
        'yandex_design_distribution_browser',
        'yandex_distproducts_browserdev_mobile_taxi',
        'yandex_infra_data_3819',
        'yandex_main_searchadv_ai',
        'yandex_main_searchadv_dep35941',
        'yandex_main_searchadv_dep75531',
        'yandex_main_searchadv_dep85477_dep10672',
        'yandex_monetize_market',
        'yandex_monetize_market_dep05174_dep09637',
        'yandex_monetize_market_dep05174_dep12123',
        'yandex_monetize_market_dep05174_dep14903',
        'yandex_monetize_market_dep05174_dep37068',
        'yandex_monetize_market_dep05174_dep73091',
        'yandex_monetize_market_marketdev',
        'yandex_monetize_market_marketdev_business_mining',
        'yandex_personal_dep06183',
        'yandex_personal_dep86518',
        'yandex_personal_vertserv',
        'yandex_rkub_bromobtech',
        'yandex_rkub_taxi_5151_8501_dep41202_dep48321',
        'yandex_search_dist_3233',
        'yandex_search_interface',
        'yandex_search_tech_assesment_toloka_dep40418',
        'yandex_search_tech_quality_component_2978',
        'yandex_search_tech_quality_component_8875',
        'yandex_search_tech_quality_robot',
        'yandex_search_tech_spam_3302',
        'yandex_search_tech_sq',
        'yandex_rkub_taxi_5151_8501',
        'yandex_rkub_taxi_dep80006',
    )

    if not any(d.url in excluded_departments for d in person.department_chain) and is_automatic_approval:
        set_auto_approve()

    elif len(heads) < 1:
        set_auto_approve()

    # ТОП менеджеры

    elif len(heads) <= 1 and country_to in rus_sng_country:
        set_auto_approve()

    # По полю в трекере ориентир на запись top_ok

    elif topmanagers in ('top_ok',):
        set_auto_approve()

    # exТакси Департамент технологических решений, Технологическая платформа

    elif any(d.url in ('yandex_distproducts_browserdev_mobile_taxi', 'yandex_monetize_market_marketdev') for d in person.department_chain):
        if len(heads) <= 2:
            pass
        else:
            add_approver(heads[-3])
        if not hrs:
            pass
        elif hrs[0] in replace_hrs and len(hrs) > 1:
            add_approver(hrs[1])
        elif hrs[0] not in ex_hrs:
            add_approver(hrs[0])
        set_auto_approve()

    # ex Управление краудсорсинга

    elif any(d.url == 'yandex_search_tech_assesment_toloka_dep40418' for d in person.department_chain) and country_to == 'Россия':
        if heads[0] == 'nosetrov' or person_login == 'nosetrov':
            add_approver(hrs[0])
        else:
            add_approver(heads[-3]) # из-за изменения структуры на стаффе условия изменились на 1
            add_approver(hrs[0])
        set_auto_approve()

    elif any(d.url in ('yandex_personal_vertserv', 'outstaff_0956', 'yandex_search_dist_3233', 'yandex_dep79124_dep69863', 'yandex_personal_dep06183', 'yandex_personal_dep86518', 'yandex_monetize_market', 'outstaff_8244', 'yandex_search_tech_quality_robot', 'yandex_search_tech_spam_3302', 'outstaff_3210_dep25037', 'yandex_search_tech_quality_component_8875', 'yandex_search_tech_quality_component_2978', 'yandex_main_searchadv_dep85477_dep10672', 'yandex_infra_data_3819', 'yandex_content_dep23951', 'yandex_monetize_market_dep05174_dep14903', 'yandex_monetize_market_dep05174_dep12123', 'yandex_monetize_market_dep05174_dep73091', 'yandex_monetize_market_dep05174_dep09637', 'yandex_monetize_market_dep05174_dep37068', 'yandex_monetize_market_marketdev_business_mining', 'yandex_main_searchadv_ai', 'yandex_rkub_bromobtech', 'yandex_design_distribution_browser', 'yandex_rkub_taxi_dep80006', 'yandex_rkub_taxi_5151_8501') for d in person.department_chain) and person_login != 'kurchanova':
        if heads[0] != author and heads[0] not in ex_heads:
            add_approver(heads[0])
        if not hrs:
            pass
        elif hrs[0] in replace_hrs and len(hrs) > 1:
            add_approver(hrs[1])
        elif hrs[0] not in ex_hrs:
            add_approver(hrs[0])
        set_auto_approve()

    elif any(d.url in (
        'yandex_search_tech_sq',
        'yandex_main_searchadv_dep35941',
        'yandex_main_searchadv_dep75531',
    ) for d in person.department_chain):
        if heads[0] != author and heads[0] not in ex_heads:
            add_approver(heads[0])
        add_approver('takarpova')

    elif any(d.url == 'as' for d in person.department_chain):
        add_approver('anna-ti')

    elif any(d.url in (
        'yandex_monetize_market_3957',
        'yandex_monetize_market_3957_3278',
        'yandex_monetize_market_dep30035',
    ) for d in person.department_chain):
        if heads[0] != author and heads[0] not in ex_heads:
            add_approver(heads[0])
        add_approver('baikinas')

    elif any(d.url == 'yandex_rkub_taxi_5151_8501_dep41202_dep48321' for d in person.department_chain):
        if heads[0] != author and heads[0] not in ex_heads:
            add_approver(heads[0])
        add_approver('stasd07')

    # По всей РФ #Андрей Короленко (andykor), Милюков Сергей (smilyukov), Вера Лейзерович (veral), Олег Смоляков (saint), Дмитрий Качмар (dkachmar), Сергей Ляджин (lyadzhin),
    # Ольга Мегорская (omegorskaya), Колесникова Марина (kolesnicova), Богин Илья (lafkadio), Джикаев Гео (dzhikaev), Казаченко Наталья (kazachenko), Емельянов Иван (iemelyanov),
    # Наумова Алёна (a-naumova), Долгов Иван (jsus), Островерх Надежда (nadyaos), Рыбаков Владимир (vladryba), Олег Коверзнев (koverznev),
    # Миронов Владислав (vladmiron), Мякинина Лариса (myakinina), Никитушкина Ольга (pumka), #Петраков Антон (apetrakov), Завражнов Павел (zavrazhnovp),
    # Бородин Владимир (d0uble), Баиндуров Сергей (sebain), Давтян Арташес (artashes), #Шульдешов Андрей (shuldeshov), Смирнова Оля (olyasmi), Шкрамко Василий (vshkramko),
    # Часовская Ольга (chasovskaya), Мовчан Артём (artem-movchan), Полоник Александр (polonik), Швецов Никита (n-shvetsov), Холод Мария (mkholod), Стрельников Иван (xplk),
    # Иванченко Евгений (zegna), Назмиев Артём (artemnazmiev), Елкин Евгений (evelkin), Юхневич Кирилл (k-yukhnevich), Тимошенко Лев (vandermond), Бабенко Максим (babenko)
    # Исакова Евгения (isakoevg), Заика Андрей (anzaika)

    elif (heads[0] in ('andykor', 'smilyukov', 'veral', 'saint', 'dkachmar', 'lyadzhin', 'omegorskaya', 'kolesnicova', 'lafkadio', 'dzhikaev', 'kazachenko', 'iemelyanov', 'a-naumova', 'jsus', 'nadyaos', 'vladryba', 'koverznev', 'vladmiron', 'myakinina', 'pumka', 'apetrakov', 'zavrazhnovp', 'd0uble', 'sebain', 'artashes', 'shuldeshov', 'olyasmi', 'vshkramko', 'chasovskaya', 'artem-movchan', 'polonik', 'n-shvetsov', 'mkholod', 'xplk', 'zegna', 'artemnazmiev', 'evelkin', 'k-yukhnevich', 'vandermond', 'babenko', 'isakoevg', 'anzaika') and country_to in ('Россия', 'Russia', 'Russian federation')):
        set_auto_approve()

    #Чернин Роман (rommich)

    elif heads[0] == 'rommich':
        set_auto_approve()

    #Алексей Башкеев (abash)

    elif (heads[0] == 'abash' and person_login == 'koverznev' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    elif ((heads[0] == 'abash' and person_login == 'dshtan' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Новосибирск', 'Novosibirsk')) or (heads[0] == 'abash' and person_login == 'dshtan' and purposeone in ('Внутренняя конференция Яндекса',))):
        set_auto_approve()

    elif (heads[0] == 'abash' and person_login == 'solar' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    elif (heads[0] == 'abash' and person_login == 'dldmitry' and country_to == 'Россия'):
        set_auto_approve()

    #Виктор Бухтояров (bkht)

    elif (heads[0] == 'bkht' and person_login == 'dldmitry' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Дмитрий Липин (dldmitry)

    elif (heads[0] == 'dldmitry' and person_login in ('efmv', 'mertas') and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Алексей Сикорский (asikorsky)

    elif (heads[0] == 'asikorsky' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Денис Быков (denisbykov)

    elif (heads[0] == 'denisbykov' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Данила Дюгуров (terry)

    elif (heads[0] == 'terry' and person_login in ('bgleb', 'rurikk') and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Карев Иван (ivan-karev)

    elif (heads[0] == 'ivan-karev' and city_to in ('Москва', 'Moscow', 'Минск', 'Minsk', 'Санкт-Петербург', 'Saint Petersburg') and purposeone in ('Рабочая встреча с коллегами', 'Обучение')):
        set_auto_approve()

    #Кацев Илья (bromozel)

    elif (heads[0] == 'bromozel' and person_login in ('ekornilina', 'kulemyakin', 'leratsoy', 'olycha', 'rboikii') and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Швец Ярослав (jaroslaw)

    #elif (heads[0] == 'jaroslaw' and person_login == 'vgorovoy' and city_to in ('Москва', 'Moscow')):
    #    set_approvement_field(approve_if_no_approvers=True)
    #    set_approvement_field(text='Командировка утверждена автоматически')

    #Копцова Екатерина (kate2110)

    elif (heads[0] == 'kate2110' and city_to in ('Москва', 'Moscow', 'Новосибирск', 'Novosibirsk', 'Санкт-Петербург', 'Saint Petersburg') and purposeone in ('Рабочая встреча с коллегами', 'Конференция')):
        set_auto_approve()

    #Стрельников Иван (xplk)

    elif (heads[0] == 'xplk' and city_to in ('Москва', 'Moscow', 'Екатеринбург', 'Yekaterinburg', 'Санкт-Петербург', 'Saint Petersburg', 'Казань')):
        set_auto_approve()

    #Мохов Олег (mokhov)

    elif (heads[0] == 'mokhov' and person_login in ('akuv', 'happyfat', 'sinseveria', 'tatsienko-ak') and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg')):
        set_auto_approve()

    elif (heads[0] == 'mokhov' and person_login == 'nastya-design' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg', 'Минск', 'Minsk' 'Симферополь', 'Simferopol')):
        set_auto_approve()

    #Плахов Андрей (finder)

    elif (heads[0] == 'finder' and city_to in ('Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Biryukov Valentin (biryuk)

    elif (heads[0] == 'biryuk' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Савченков Леонид (savchleo)

    elif (heads[0] == 'savchleo' and city_to in ('Москва', 'Moscow', 'Новосибирск', 'Novosibirsk', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg')):
        set_auto_approve()

    #Ивахненко Никита (nik-iv)

    elif (heads[0] == 'nik-iv' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Аминова Лилия (l-aminova)

    elif (heads[0] == 'l-aminova' and person_login == 'morozova87' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Куликов Сергей (sakulikov)

    elif (heads[0] == 'sakulikov' and city_to in ('Краснодар', 'Krasnodar', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Устинов Юрий (ustr)

    elif (heads[0] == 'ustr' and city_to in ('Москва', 'Moscow', 'Нижний Новгород', 'Nizhniy Novgorod', 'Минск', 'Minsk')):
        set_auto_approve()

    #Куликов Владимир (vlkl)

    #elif (heads[0] == 'vlkl' and person_login == 'bazankova' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
    #    set_approvement_field(approve_if_no_approvers=True)
    #    set_approvement_field(text='Командировка утверждена автоматически')

    #Королёв Алексей (korolyov)

    elif (heads[0] == 'korolyov' and person_login in ('damir-vvlpx', 'grigor-vlad', 'ilyakis') and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Новосибирск')):
        set_auto_approve()

    #Левчук Олег (levchuk)

    elif (heads[0] == 'levchuk' and person_login == 'denisbykov' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Страхов Артём (dukeartem)

    elif (heads[0] == 'dukeartem' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg')):
        set_auto_approve()

    #Мороз Степан (smoroz)

    elif (heads[0] == 'smoroz' and country_to == 'Россия' and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Москвичев Александр (norecces)

    elif (heads[0] == 'norecces' and person_login == 'utterstep' and country_to == 'Россия'):
        set_auto_approve()

    #Vysotskiy Alexander (avysotsky)

    elif (heads[0] == 'avysotsky' and person_login == 'anton-zykov' and country_to == 'Россия'):
        set_auto_approve()

    #Kurilov Dmitriy (dmkurilov)

    elif (heads[0] == 'dmkurilov' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Дементьев Дмитрий (dmitrdem)

    elif (heads[0] == 'dmitrdem' and person_login in ('androidtim', 'gudmian', 'svyat-starkov') and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Лукманов Роман (ko4evnik)

    elif (heads[0] == 'ko4evnik' and person_login == 'edragun' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Новосибирск', 'Novosibirsk')):
        set_auto_approve()

    #Володин Роман (roman-volodin)

    elif (heads[0] == 'roman-volodin' and person_login == 'izapolsky' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Ищенко Александр (aishchenko)

    elif (heads[0] == 'aishchenko' and person_login == 'rbudchenko' and country_to == 'Россия'):
        set_auto_approve()

    #Белотицкий Вадим (vadim-b)

    elif (heads[0] == 'vadim-b' and person_login == 'k-snegov' and city_to in ('Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    elif (heads[0] == 'vadim-b' and person_login == 'kramig' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Штань Данила (dshtan)

    elif (heads[0] == 'dshtan' and person_login == 'dmitko' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Овчаренко Егор (e-ovcharenko)

    elif (heads[0] == 'e-ovcharenko' and city_to in ('Москва', 'Moscow') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Усков Сергей (s-uskov)

    elif (heads[0] == 's-uskov' and person_login == 'lyapital' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Ронжин Петр (peleron)

    elif (heads[0] == 'peleron' and person_login in ('yeviv', 'nadolin', 'vasilyev-n', 'viktorev') and country_to == 'Россия'):
        set_auto_approve()

    #Кузьмин Павел (kuzmin-pb)

    elif (heads[0] == 'kuzmin-pb' and person_login == 'ysidelev' and country_to == 'Россия'):
        set_auto_approve()

    #Кочарян Юрий (kocharyan)

    elif (heads[0] == 'kocharyan' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Резников Илья (richard)

    elif any(d.url == 'yandex_monetize_market_marketdev_dep55856_dep85792' for d in person.department_chain) and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow'):
        set_auto_approve()

    #Шутов Борис (borkk)

    elif (heads[0] == 'borkk' and city_to in ('Екатеринбург', 'Москва', 'Moscow')):
        set_auto_approve()

    #Холодов Глеб (glebkhol)

    elif (heads[0] == 'glebkhol' and person_login in ('kostya-k', 'qkrorlqr', 'valesini') and city_to in ('Москва', 'Moscow', 'Новосибирск', 'Novosibirsk', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Звонкова Екатерина (evzvonkova)

    elif (heads[0] == 'evzvonkova' and person_login == 'denis-shulga' and city_to in ('Москва', 'Moscow', 'Новосибирск', 'Novosibirsk', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg', 'Ростов-на-Дону', 'Rostov-on-Don', 'Cамара', 'Samara', 'Омск', 'Omsk', 'Красноярск', 'Krasnoyarsk', 'Нижний Новгород', 'Nizhniy Novgorod', 'Липецк', 'Lipetsk', 'Сочи', 'Sochi', 'Ярославль', 'Yaroslavl')):
        set_auto_approve()

    #Бочкарев Алексей (bochkarev)

    elif (heads[0] == 'bochkarev' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Пендюрин Артём (ertema)

    elif (heads[0] == 'ertema' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Екатеринбург', 'Yekaterinburg')):
        set_auto_approve()

    #Фролов Антон (anton-fr)

    elif (heads[0] == 'anton-fr' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Куликова Женя (lilosea)

    elif (heads[0] == 'lilosea' and person_login == 'voirina' and country_to == 'Россия'):
        set_auto_approve()

    #Стриженок Сергей (sstrizhenok)

    elif (heads[0] == 'sstrizhenok' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Новичков Михаил (novichkovm)

    elif (heads[0] == 'novichkovm' and person_login == 'sherbinin-k' and country_to == 'Россия'):
        set_auto_approve()

    #Коробейникова Марина (tweety)

    elif (heads[0] == 'tweety' and person_login == 'savelevt' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Лукьянов Александр (lucius)

    elif (heads[0] == 'lucius' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Прошутинская Светлана (podnebesnaya)

    elif (heads[0] == 'podnebesnaya' and person_login in ('avgan', 'cmind') and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Екатеринбург', 'Yekaterinburg') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Попов Сергей (sukhoi)

    elif (heads[0] == 'sukhoi' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Слесарев Антон (slesarev)

    elif (heads[0] == 'slesarev' and person_login in ('dmitryka', 'rudovichenko') and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Федоренко Екатерина (fedorenko-es)

    elif (heads[0] == 'fedorenko-es' and person_login == 'valmikhno' and city_to in ('Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Гуменникова Анастасия (gumennikova)

    elif (heads[0] == 'gumennikova' and person_login in ('juliascript', 'nermohin') and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Федорова Катя (peekaboo)

    elif (heads[0] == 'peekaboo' and person_login == 'karim' and country_to == 'Россия'):
        set_auto_approve()

    #Drutsa Alexey (adrutsa)

    elif (heads[0] == 'adrutsa' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Шелехов Данил (dvshelehov)

    elif (heads[0] == 'dvshelehov' and person_login in ('bagirov', 'elinakiyko', 'pavelrasputin', 'shikarina', 'vladimirnes') and country_to in ('Россия', 'Беларусь', 'Belarus') and purposeone in ('Рабочая встреча с коллегами', 'Деловые переговоры с внешними партнерами', 'Внутренняя конференция Яндекса')):
        set_auto_approve()

    #Турчановская Ольга (leeuw)

    elif (heads[0] == 'leeuw' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Екатеринбург', 'Yekaterinburg') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Лупач Константин (lupach)

    elif (heads[0] == 'lupach' and person_login == 'gwaeren' and city_to in ('Нижний Новгород', 'Nizhniy Novgorod') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Миловидов Алексей (milovidov)

    elif (heads[0] == 'milovidov' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Коншина Вера (verakonshina)

    elif (heads[0] == 'verakonshina' and person_login == 'lana1114' and city_to in ('Москва', 'Moscow', 'Томилино', 'Tomilino')):
        set_auto_approve()

    #Антипов Сергей (antipich)

    elif (heads[0] == 'antipich' and person_login in ('aliho', 'azhakov', 'forest-ax', 'lupach') and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Морозов Роман (romanmoroz)

    elif (heads[0] == 'romanmoroz' and country_to in ('Россия', 'Беларусь', 'Belarus') and purposeone in ('Рабочая встреча с коллегами', 'Деловые переговоры с внешними партнерами')):
        set_auto_approve()

    #Замулла Алексей (zamulla)

    elif (heads[0] == 'zamulla' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Екатеринбург', 'Yekaterinburg')):
        set_auto_approve()

    #Шуберт Алексей (shubert)

    elif (heads[0] == 'shubert' and city_to in ('Екатеринбург', 'Yekaterinburg')):
        set_auto_approve()

    elif (heads[0] == 'shubert' and person_login == 'yurikiselev' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Морозов Семён (semyonmo)

    elif (heads[0] == 'semyonmo' and person_login == 'vkorbut' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Шлюнкин Алексей (sankear)

    elif (heads[0] == 'sankear' and person_login == 'chertkova' and country_to == 'Россия'):
        set_auto_approve()

    #Carson Nate (natecarson)

    elif (heads[0] == 'natecarson' and person_login == 'rosmiyana' and city_to in ('Санкт-Петербург', 'Saint Petersburg') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Verkhoglyad Alexander (hexode)

    elif (heads[0] == 'hexode' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Минск', 'Minsk')):
        set_auto_approve()

    #Михайлов Дмитрий (dmitry-mik)

    elif (heads[0] == 'dmitry-mik' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Минск', 'Minsk') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Grigorev Artem (ortemij)

    elif (heads[0] == 'ortemij' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Минск', 'Minsk')):
        set_auto_approve()

    #Матюнин Александр (matiunin)

    elif (heads[0] == 'matiunin' and country_to in ('Россия',) and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Башьян Филипп (philbashyan)

    elif (heads[0] == 'philbashyan' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Петров Вадим (vadim-petrov)

    elif (heads[0] == 'vadim-petrov' and person_login == 'artashes' and country_to == 'Россия'):
        set_auto_approve()

    #Чернышев Сергей (chernysh)

    elif (heads[0] == 'chernysh' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Русинов Владимир (rusinov)

    elif (heads[0] == 'rusinov' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Губанов Сергей (esgv)

    elif (heads[0] == 'esgv' and person_login == 'antonio' and city_to in ('Москва', 'Moscow') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Тупикова (Котина) Елена (kotina)

    elif (heads[0] == 'kotina' and city_to in ('Саратов', 'Saratov', 'Воронеж', 'Voronezh')):
        set_auto_approve()

    #Clayhills Anthon (clayhills)

    elif (heads[0] == 'clayhills' and purposeone in ('Обучение',)):
        set_auto_approve()

    #Karpova Lyubov (lubovka)

    elif (heads[0] == 'lubovka' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg', 'Минск', 'Minsk')):
        set_auto_approve()

    #Морозов Семён (semyonmo)

    elif (heads[0] == 'semyonmo' and person_login in ('eduardtrayan', 'vkorbut') and country_to == 'Россия'):
        set_auto_approve()

    #Лыточкин Борис (lytboris)

    elif (heads[0] == 'lytboris' and country_to in ('Россия',) and purposeone in ('Инженерно-монтажные работы', 'Производство, посещение объектов, приемка работ', 'Поддержка ИТ-инфраструктуры')):
        set_auto_approve()

    #Ларионова Екатерина (k-lario)

    elif (heads[0] == 'k-lario' and person_login == 'irina-pedino' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Белова Илария (ilariia)

    elif (heads[0] == 'ilariia' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Рой Наталья (selivanova-ns)

    elif (heads[0] == 'selivanova-ns' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Дмитриева Анжела (anzhela-d)

    elif (heads[0] == 'anzhela-d' and person_login == 'di-bakieva' and country_to == 'Россия' and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Аброськин Петр (abroskin)

    elif (heads[0] == 'abroskin' and person_login == 'novikova' and city_to in ('Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Попов Петр (ironpeter)

    elif (heads[0] == 'ironpeter' and person_login == 'omegorskaya' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Дзевщепольская Наташа (npolskaya)

    elif (heads[0] == 'npolskaya' and person_login == 'polinaboyko' and country_to == 'Россия'):
        set_auto_approve()

    #Николаев Кирилл (kvn)

    elif (heads[0] == 'kvn' and person_login == 'bromozel' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Федоров Сергей (talys-cat)

    elif (heads[0] == 'talys-cat' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg') and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Малайрев Александр (aabb)

    elif (heads[0] == 'aabb' and city_to in ('Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Усталов Дмитрий (dustalov)

    elif (heads[0] == 'dustalov' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg') and purposeone in ('Рабочая встреча с коллегами', 'Обучение')):
        set_auto_approve()

    #Животворев Николай (nizhi)

    elif any(d.url == 'yandex_rkub_discovery_rec_6136_dep08029_dep08434' for d in person.department_chain) and country_to == 'Россия':
        set_auto_approve()

    #Стрелковский Андрей (qkrorlqr)

    elif (heads[0] == 'qkrorlqr' and person_login in ('haposik', 'svartmetal', 'tpashkin', 'wilytiger', 'ymoskalenk0') and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Epikhin Mikhail (schizophrenia)

    elif (heads[0] == 'schizophrenia' and country_to == 'Россия' and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Алексеев Артём (alekseev22)

    elif (heads[0] == 'alekseev22' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Белугин Владимир (vladbelugin)

    elif (heads[0] == 'vladbelugin' and person_login == 'kolesnicova' and country_to == 'Россия'):
        set_auto_approve()

    #Бобровская Лариса (bobrovskaya)

    elif (heads[0] == 'bobrovskaya' and person_login == 'yuri-smirnov' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Масюк Дмитрий (dmasyuk)

    elif (heads[0] == 'dmasyuk' and person_login == 'maxavt' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Колмогорцев Егор (zizu)

    elif (heads[0] == 'zizu'and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Лядова Юлия (lyadovayuliya)

    elif (heads[0] == 'lyadovayuliya' and person_login in ('koroleva-e', 'sysolyatina-d') and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Николаев Михаил (nkey)

    elif (heads[0] == 'nkey' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Гапонова Оксана (capgap)

    elif (heads[0] == 'capgap' and person_login == 'antlin' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Носов Дмитрий (dmitryno)

    elif (heads[0] == 'dmitryno' and person_login == 'mashko' and city_to in ('Москва', 'Moscow', 'Санкт-Петербург', 'Saint Petersburg')):
        set_auto_approve()

    #Григорий Дергачев (liumin)

    elif (heads[0] == 'liumin' and country_to in ('Россия', 'Беларусь', 'Belarus')):
        set_auto_approve()

    #Лосева Екатерина (kateloseva)

    elif (heads[0] == 'kateloseva' and person_login == 'voskhod' and city_to in ('Москва', 'Moscow') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Соболев Никита (nksobolev)

    elif (heads[0] == 'nksobolev' and person_login == 'kurchanova' and country_to == 'Россия'):
        set_auto_approve()

    #Потапов Артём (potapart)

    elif (heads[0] == 'potapart' and person_login in ('chemerkinaa', 'olbeorn') and country_to == 'Россия'):
        set_auto_approve()

    #Фёдорова Наталья (sterh)

    elif (heads[0] == 'sterh' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Андреев Владимир (vlandreev)

    elif (heads[0] == 'vlandreev' and city_to in ('Сочи', 'Sochi', 'Москва', 'Moscow')):
        set_auto_approve()

    #Готманов Александр (gotmanov)

    elif (heads[0] == 'gotmanov' and person_login in ('ibrishat', 'vdmit') and country_to == 'Россия'):
        set_auto_approve()

    #Трошев Михаил (mishanga)

    elif (heads[0] == 'mishanga' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow', 'Екатеринбург', 'Yekaterinburg', 'Минск', 'Minsk') and purposeone in ('Рабочая встреча с коллегами',)):
        set_auto_approve()

    #Вельтищев Дмитрий (vdmit)

    elif (heads[0] == 'vdmit' and person_login in ('dergunov', 'knyshovalex') and country_to == 'Россия'):
        set_auto_approve()

    #Лапин Александр (avlapin)

    elif (heads[0] == 'avlapin' and person_login == 'tamaznn' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Тишин Сергей (tishins)

    elif (heads[0] == 'tishins' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Архипов Евгений (arhipov)

    elif (heads[0] == 'arhipov' and person_login in ('alex-burmak', 'pperekalov') and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Семенова Валентина (adgval)

    elif (heads[0] == 'adgval' and person_login in ('be-belko', 'tsymbalava') and country_to == 'Россия'):
        set_auto_approve()

    #Зимовнов Андрей (zian)

    elif any(d.url == 'yandex_rkub_discovery_rec_6136_dep82101' for d in person.department_chain) and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow') and purposeone == 'Рабочая встреча с коллегами':
        set_auto_approve()

    #Епишин Павел (epic)

    elif (heads[0] == 'epic' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Исмагилов Руслан (isruslan)

    elif (heads[0] == 'isruslan' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Рустамова Яна (yrustamova)

    elif (heads[0] == 'yrustamova' and person_login in ('nephila', 'qelper', 'shabalinrl') and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Архипова Ольга (olycha)

    elif any(d.url == 'yandex_search_tech_assesment_analysis_infsocial' for d in person.department_chain) and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow'):
        set_auto_approve()

    #Егоров Никита (zlokelin)

    elif (heads[0] == 'zlokelin' and city_to in ('Санкт-Петербург', 'Saint Petersburg') and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Лебёдкина Елена (evlebedkina)

    elif (heads[0] == 'evlebedkina' and person_login in ('chumakoff', 'dv-berdnikov','tersteg') and country_to == 'Россия'):
        set_auto_approve()

    #Перегон Ольга (olru)

    elif (heads[0] == 'olru' and country_to == 'Россия' and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Стельмашук Надя (owlet)

    elif (heads[0] == 'owlet' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    #Харди Арам (aramhardy)

    elif (heads[0] == 'aramhardy' and person_login in ('gaskarov', 'arepyeva') and city_to in ('Москва', 'Moscow') and purposeone == 'Рабочая встреча с коллегами'):
        set_auto_approve()

    #Назир Даштиев (dashtiev)

    elif (heads[0] == 'dashtiev' and person_login == 'myrashov' and city_to in ('Москва', 'Moscow')):
        add_approver(hrs[0])

    #Федоров Дмитрий (dmifedorov)

    elif (heads[0] == 'dmifedorov' and person_login == 'thenno' and city_to in ('Москва', 'Moscow')):
        set_auto_approve()

    #Лебедев Евгений (ealebedev)

    elif (heads[0] == 'ealebedev' and city_to in ('Санкт-Петербург', 'Saint Petersburg', 'Москва', 'Moscow')):
        set_auto_approve()

    elif (((purposeone in ('Обучение', 'Рекрутинг', 'Внутренняя конференция Яндекса', 'Рабочая встреча с коллегами')) or (purposetwo in ('Обучение', 'Рекрутинг', 'Внутренняя конференция Яндекса', 'Рабочая встреча с коллегами')))and purposeone != 'Внешняя конференция' and purposeone != 'Корпоративное мероприятие' and purposeone != 'Кампус' and purposetwo != 'Внешняя конференция' and purposetwo != 'Корпоративное мероприятие' and purposetwo != 'Кампус' and country_to in ('Россия', 'Беларусь', 'Belarus', 'Russia')):
        if heads[0] == 'pavel-b':
            add_approver('korotkina'),
        if heads[0] == 'ekvoloboy':
            add_approver('angelina-iln'),
        if heads[0] == 'demyashkevich':
            add_approver('adnovgorodova'),
        if heads[0] == 'pavlovao':
            add_approver('abelousov'),
        if heads[0] == 'asavinovsky':
            add_approver('imago'),
        if heads[0] == 'grishakov':
            add_approver('yana-ya'),
        if (heads[0] != author and heads[0] not in ex_heads):
            add_approver(heads[0])

    elif any(d.url == 'yandex_mnt' for d in person.department_chain) and city_to in ('Владимир', 'Vladimir',  'Сасово', 'Sasovo', 'Мытищи', 'Mytischi'):
        if heads[0] != author:
            add_approver(heads[0])
        set_auto_approve()

    elif any(d.url == 'yandex_mnt_1500_3591' for d in person.department_chain):
        add_approver('agusev')

    elif any(d.url in ('yandex_rkub_taxi_selfdriven', 'outstaff_2289_dep91054', 'yandex_main_searchadv_9641', 'outstaff_2289_dep08975_dep01136_dep16322', 'outstaff_3210_dep07623', 'yandex_content', 'outstaff_3676', 'outstaff_8244_dep68772') for d in person.department_chain) and country_to == 'Россия':
        if (heads[0] != author and heads[0] not in ex_heads):
            add_approver(heads[0])
        set_auto_approve()

    elif any(d.url in ('yandex', 'outstaff') for d in person.department_chain):
        if heads[0] == 'pavel-b':
            add_approver('korotkina'),
        if heads[0] == 'ekvoloboy':
            add_approver('angelina-iln'),
        if heads[0] == 'demyashkevich':
            add_approver('adnovgorodova'),
        if heads[0] == 'pavlovao':
            add_approver('abelousov'),
        if heads[0] == 'asavinovsky':
            add_approver('imago'),
        if heads[0] == 'grishakov':
            add_approver('yana-ya'),
        if (heads[0] != author and heads[0] not in ex_heads):
            add_approver(heads[0])
        if not hrs:
            pass
        elif hrs[0] in replace_hrs and len(hrs) > 1:
            add_approver(hrs[1])
        elif hrs[0] not in ex_hrs:
            add_approver(hrs[0])
        set_auto_approve()


if not DEV_MODE:
    main(params)
