def get_dev_mode():
    try:
        import os
    except ImportError:
        return False
    return bool(int(os.getenv('DEV_MODE', 0)))


DEV_MODE = get_dev_mode()
if DEV_MODE:
    from unittest.mock import MagicMock
    flow_api = MagicMock()
    add_approvers_group = MagicMock()
    set_approvement_field = MagicMock()


exclude_heads = {
    'volozh',
    'tigran',
}

# TODO OK-1409: Описать замены
replace_heads_map = {}


def get_approvers(heads_logins):
    if not heads_logins:
        return []
    approvers = []
    direct_head_login = heads_logins[0]
    if direct_head_login in replace_heads_map:
        approvers.append(replace_heads_map[direct_head_login])
    approvers.extend(heads_logins)
    approvers.append('robot-ok-tracker')
    approvers = reversed(dict.fromkeys(reversed(approvers)))
    return [i for i in approvers if i not in exclude_heads]

def main(params):
    employee_login = params['employee']
    employee = flow_api.Person(employee_login)
    heads = employee.heads_chain
    heads_logins = [h.login for h in heads]
    approvers = get_approvers(heads_logins)
    if approvers:
        add_approvers_group(approvers, is_with_deputies=True)
        set_approvement_field(
            text=(
                f'У укого:{employee_login} запланирован отпуск. '
                f'Подтвердите, пожалуйста.\nPlease confirm the vacation for кто:{employee_login}.'
            ),
            is_reject_allowed=False,
        )
    else:
        set_approvement_field(
            approve_if_no_approvers=True,
            text='Отпуск согласован автоматически.\nThe vacation was automatically approved.',
        )


if not DEV_MODE:
    main(params)
