# coding: utf-8
import os
import ftplib
import datetime
import logging
import json
from get_api_staff import get_data


FTP_IP, FTP_LOGIN = '64:ff9b::57e5:e85e', 'yandex'
FTP_PASS = os.getenv('FTP_PASS', 'B6asWe%rh&')
# yav get version sec-01f7tyse8qd3fr5534bg2ahmt7 -o FTP_PASS
# yav get version sec-01f35s2537s2d6sed431k7a8kj -o oauth-token

HEADER = '''<?xml version="1.0" encoding="UTF-8"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:html="http://www.w3.org/TR/REC-html40">
  <Worksheet ss:Name="Новая заявка">
<Table ss:ExpandedColumnCount="24" ss:ExpandedRowCount="5" x:FullColumns="1" x:FullRows="1" ss:DefaultRowHeight="15">
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Column ss:Width="250"/>
      <Row>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
      </Row>
      <Row>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
        <Cell>
          <Data ss:Type="String"></Data>
        </Cell>
      </Row>
      <Row>
        <Cell>
          <Data ss:Type="String">Компания</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Ф.И.О</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Бизнес номер</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">UID (DEC)</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">UID (HEX)</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Марка авто</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Госномер авто</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Группа</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Статус</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Срок начала действия карты</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Срок окончания действия карты</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Срок начала действия автомобиля</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Срок окончания действия автомобиля</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Модель  авто</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Цвет  авто</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Тип  авто</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Фамилия</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Имя</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Отчество</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Комментарии</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Идентификатор сессии</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Тип идентификатора</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Cумма</Data>
        </Cell>
        <Cell>
          <Data ss:Type="String">Кол-во проездов</Data>
        </Cell>
      </Row>
      <Row>
        <Cell>
          <Data ss:Type="Number">1</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">2</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">3</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">4</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">5</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">6</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">7</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">8</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">9</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">10</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">11</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">12</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">13</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">14</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">15</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">16</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">17</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">18</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">19</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">20</Data>
        </Cell>
        <Cell>
          <Data ss:Type="Number">21</Data>
        </Cell>
      </Row>'''
FOOTER = '''    </Table>
  </Worksheet>
</Workbook>
'''


def dectohex(num: str) -> str:
    table = {0: '0', 1: '1', 2: '2', 3: '3', 4: '4', 5: '5', 6: '6', 7: '7', 8: '8', 9: '9',
             10: 'A', 11: 'B', 12: 'C', 13: 'D', 14: 'E', 15: 'F'}
    value = int(num)
    s: str = ''
    while value > 0:
        s = table[value % 16] + s
        value //= 16
    s_str: str = ''
    if len(s) % 2 == 1:
        s = '0' + s
    for i in range(0, len(s)-1, 2):
        s_str = s[i] + s[i+1] + s_str
    return s_str


def save_data_to_file(my_details: list = [], count: int = 30, filename: str = ''):
    filename = filename + f'{count:03d}.dat'
    with open(filename, 'w', encoding='utf8') as json_file:
        json.dump(my_details, json_file, ensure_ascii=False)


def load_data_from_file(count: int = 100, filename: str = '') -> dict:
    filename = filename + f'{count:03d}.dat'
    try:
        with open(filename, 'r', encoding='utf8') as json_file:
            json_data = json.load(json_file)
    except FileNotFoundError as e:
        log.info(f'Error: {e}')
        exit()
    return json_data


def get_body(load_data: list) -> str:
    outdata: str = ''
    date_s = datetime.datetime.now().strftime('%Y-%m-%dT%H:%M:%S')
    for login, f_name, l_name, location, id_badges, cars, todo in load_data:
        if id_badges != '' and cars != []:
            is_active = 1  # 1 - активна, 2 - блокировка
            date_e = (datetime.datetime.now() + datetime.timedelta(days=720)).strftime('%Y-%m-%dT%H:%M:%S')
            if todo == 'delete':
                is_active = 2
                date_e = date_s
                cars: list = [{'plate': 'о111оо111', 'model': 'удалена'}]
            for car in cars:
                gos_sign = str(car['plate']).replace(' ', '')
                hex_s: str = dectohex(id_badges)
                outdata += "<Row>\n"
                outdata += "<Cell><Data ss:Type=\"String\">Яндекс</Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{login}</Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{id_badges}</Data></Cell>\n"  # ID badge
                outdata += f"<Cell><Data ss:Type=\"String\">{hex_s}</Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{gos_sign}</Data></Cell>\n"  # Car plate
                outdata += "<Cell><Data ss:Type=\"String\">9</Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{is_active}</Data></Cell>\n"  # StatusCard
                outdata += f"<Cell><Data ss:Type=\"String\">{date_s}</Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{date_e}</Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{date_s}</Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{date_e}</Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{car['model']}</Data></Cell>\n"  # model auto
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
# высотомер 0 or None - нет, 1-без высотомера, 2-высота2м, 3-от2,5метров
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += f"<Cell><Data ss:Type=\"String\">{login}</Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\">bf17ad2b-64d2-47d5-a3a6-07d104904ea8</Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\">5</Data></Cell>\n"  # Всегда !5! это внешние карты
                outdata += "<Cell><Data ss:Type=\"String\"></Data></Cell>\n"
                outdata += "<Cell><Data ss:Type=\"String\">0</Data></Cell>\n"
                outdata += "</Row>\n"
    return HEADER + outdata + FOOTER


def get_diff(new_data: list, old_data: list) -> list:
    todo_data: list = []
# Добавляем, обновляем
    for login, f_name, l_name, location, id_badges, cars in new_data:
        not_found: int = 1
        for key2 in old_data:
            if login == key2[0]:
                not_found = 0
                if id_badges != key2[4] or cars != key2[5]:
                    todo_data.append((login, f_name, l_name, location, id_badges, cars, 'update',))
        if not_found == 1:
            todo_data.append((login, f_name, l_name, location, id_badges, cars, 'add',))
# Удаляем
    for login, f_name, l_name, location, id_badges, cars in old_data:
        not_found = 1
        for key2 in new_data:
            if login == key2[0]:
                not_found = 0
        if not_found == 1:
            todo_data.append((login, f_name, l_name, location, id_badges, cars, 'delete',))
    return todo_data


def get_filenum() -> int:
    ftp = ftplib.FTP_TLS(host=FTP_IP, timeout=60)
    ftp.set_pasv(True)
    ftp.login(FTP_LOGIN, FTP_PASS)
    ftp.prot_p()
    lines = ftp.nlst("-t CardList_*")
    ftp.close()
    latest_name = lines[-1]
    last_file_number = int(latest_name.split('_')[1].split('.')[0])
    return last_file_number + 1


def push_file_to_xml(data: str = '', i: int = 100):
    filename = 'CardList_' + f'{i:03d}.xml'
    with open(filename, 'w', encoding='utf8') as upload_file:
        upload_file.write(data)


def ftp_file_transfer(i: int = 100):
    filename = 'CardList_' + f'{i:03d}.xml'
    ftp = ftplib.FTP_TLS(host=FTP_IP, timeout=60)
    ftp.set_pasv(True)
    ftp.login(FTP_LOGIN, FTP_PASS)
    ftp.prot_p()
    with open(filename, 'rb') as upload_file:
        log.info(f'Try to transfer: {filename}')
        try:
            ftp.storlines('STOR ' + filename, upload_file)
        except ftplib.all_errors as e:
            log.info(f'Timeout :( with transfer: {filename}:{e}')
    ftp.close


def main_data_transfer():
    staff_data: list = []
    file_num: int = get_filenum()
    log.info(f'File number: {file_num:03d}')

    log.info('Get Staff Data...')
    try:
        for login, f_name, l_name, location, id_badges, cars in get_data():
            if id_badges != '' and cars != []:
                staff_data.append((login, f_name, l_name, location, id_badges, cars,))
    except RuntimeError as e:
        log.info(f'Error with OAUTH: {e}')
        exit(2)
    staff_old_data = load_data_from_file(file_num-1, self_file_name)

    log.info('Get defference')
    todo_data = get_diff(staff_data, staff_old_data)

    log.info('Get body')
    body = get_body(todo_data)

    log.info('Save file')
    push_file_to_xml(body, file_num)
    save_data_to_file(staff_data, file_num, self_file_name)
    ftp_file_transfer(file_num)


if __name__ == '__main__':
    self_file_name = os.path.splitext(__file__)[0]
    logging.basicConfig(
            filename=self_file_name + '.log',
            format='%(asctime)s:%(name)s:%(levelname)s:%(message)s',
            level=logging.INFO
    )
    log = logging.getLogger('MARRIOTT')
    log.info('Start...')
    main_data_transfer()
    log.info('End.\n')
