import os
import json
import requests
import logging
from file_import_utils import get_secret_from_yav, prepare_for_logging

LOG_FILE = f'{os.path.splitext(__file__)[0]}.log'
LOG_FILE_TO_SEND = 'cee400_result.txt'
MAIL_TO = ['diff_another@yandex-team.ru', 'shornin@yandex-team.ru']

YAV_TOKEN = os.getenv('YAV_TOKEN', '')
OAUTH_TOKEN = get_secret_from_yav('sec-01fsp1b2bf5mtbz9yp4kgy8v8d', 'startrack_oauth', YAV_TOKEN)
STARTRACKAPI_HOST = 'st-api.yandex-team.ru'


def startrack_api_issues(filter_params: dict = None) -> dict:
    filter_params = filter_params or {}
    params = {
        'filter': {
            'queue': 'CEE',
            'status': 'verifying',
        }
    }
    params.update(filter_params)
    startrack_session = requests.Session()
    startrack_session.headers.update({'Authorization': f'OAuth {OAUTH_TOKEN}'})
    startrack_session.headers.update({'Content-Type': 'application/json'})
    response = startrack_session.post(
            url=f'https://{STARTRACKAPI_HOST}/v2/issues/_search?perPage=15',
            data=json.dumps(params),
    )

    if response.status_code != 200:
        raise RuntimeError(f'{response.status_code}: {response.content}')
    return response.json()


def get_status_on_webhook(issue_id: str) -> list:
    trigger = 32523
    queue = 'CEE'
    startrack_session = requests.Session()
    startrack_session.headers.update({'Authorization': f'OAuth {OAUTH_TOKEN}'})
    startrack_session.headers.update({'Content-Type': 'application/json'})
    response = startrack_session.get(
            url=f'https://{STARTRACKAPI_HOST}/v2/queues/{queue}/triggers/{trigger}/webhooks/log/?issueId={issue_id}',
    )
    if response.status_code != 200:
        raise RuntimeError(f'{response.status_code}: {response.content}')
    return response.json()


def issue_change_status(issue: str, transition: str, resolution: dict = None):
    resolution = resolution or {}
    startrack_session = requests.Session()
    startrack_session.headers.update({'Authorization': f'OAuth {OAUTH_TOKEN}'})
    startrack_session.headers.update({'Content-Type': 'application/json'})
    response = startrack_session.post(
            url=f'https://{STARTRACKAPI_HOST}/v2/issues/{issue}/transitions/{transition}/_execute',
            data=json.dumps(resolution)
    )
    if response.status_code != 200:
        raise RuntimeError(f'{response.status_code}: {response.content}')
    return response.json()


def issue_add_comment(issue: str, text: str):
    data = {
        'text': text,
        # 'summonees': ['helther'],
    }
    startrack_session = requests.Session()
    startrack_session.headers.update({'Authorization': f'OAuth {OAUTH_TOKEN}'})
    startrack_session.headers.update({'Content-Type': 'application/json'})
    response = startrack_session.post(
            url=f'https://{STARTRACKAPI_HOST}/v2/issues/{issue}/comments',
            data=json.dumps(data)
    )
    if response.status_code != 201:
        raise RuntimeError(f'{response.status_code}: {response.content}')
    return response.json()


def main():
    error_text = 'Ошибка 400: переотправка'
    issues_dict = startrack_api_issues()
    for issue in issues_dict:
        logs_webhook = get_status_on_webhook(issue['id'])
        last_log_webhook = logs_webhook[-1]
        logging.info(f"{issue['key']} id: {issue['id']}, "
                     f"StatusCode: {last_log_webhook['response']['statusCode']}")
        if last_log_webhook['response']['statusCode'] == 400:
            logging.info(f"Добавлен комментарий: {issue['key']} {error_text}")
            issue_add_comment(issue['key'], error_text)
    return None


if __name__ == '__main__':
    prepare_for_logging(LOG_FILE, LOG_FILE_TO_SEND)
    main()
    logging.info('----------------------')
