import datetime
from file_import_utils import send_email, get_sql_request_from_lenels

# LOG_FILE = f'{os.path.splitext(__file__)[0]}.log'
# LOG_FILE_TO_SEND = 'amalteya_result.txt'
MAIL_TO = ['amalteya_persons@yandex-team.ru']


def main() -> None:
    date_s = datetime.datetime.now()
    # from_address = 'Amalteya Persons <noreply@yandex-team.ru>'
    query = '''SET NOCOUNT ON;
    SELECT TOP(1) COUNT(DISTINCT [ACCESSCONTROL].[dbo].[EVENTS].[CARDNUM])
    FROM [ACCESSCONTROL].[dbo].[EVENTS] WITH (nolock)
    WHERE [ACCESSCONTROL].[dbo].[EVENTS].[EMPID] <> 0
    AND [ACCESSCONTROL].[dbo].[EVENTS].[EVENTTYPE] = 0
    AND EVENT_TIME_UTC BETWEEN DATEADD(HOUR, -24, GETUTCDATE()) AND GETUTCDATE()
    AND [ACCESSCONTROL].[dbo].[EVENTS].[MACHINE] IN (640,641,642)'''
    number = get_sql_request_from_lenels('lenrus', query)[0][0]
    subject = 'Отчет о посещении офиса Яндекса (БЦ Амальтея)'
    body_message = 'Письмо было сгенерировано роботом, пожалуйста, не отвечайте на него.<BR><BR>'\
                   f'Дата: {date_s.strftime("%d-%m-%Y")}'\
                   f'<BR>Офис: Москва, БЦ Амальтея<BR>Всего: {number}'
    send_email(MAIL_TO, subject, body_message, [])
    return None


if __name__ == '__main__':
    main()
