import os
import re
import json
import requests
import logging
from file_import_utils import (
    get_secret_from_yav,
    send_email,
    prepare_for_logging,
    get_accesslevels_from_lenel,
)

LOG_FILE = f'{os.path.splitext(__file__)[0]}.log'
LOG_FILE_TO_SEND = 'lenel_wiki_result.txt'
MAIL_TO = ['diff_another@yandex-team.ru']
URL_HOST = 'wiki-api.yandex-team.ru'
YAV_TOKEN = os.getenv('YAV_TOKEN', '')
OAUTH_TOKEN = get_secret_from_yav('sec-01f35s2537s2d6sed431k7a8kj', 'oauth-token', YAV_TOKEN)
REQUEST_URL = 'users/shornin/urovni-dostupa-soglasujushhie'
EXCLUDE_LEVELS = {2, 23, 47, 55}


def get_wiki_accesslevels() -> dict:
    wiki_session = requests.Session()
    wiki_session.headers.update({'Authorization': f'OAuth {OAUTH_TOKEN}',
                                 'Content-Type': 'application/json'})
    response = wiki_session.get(url=f'https://{URL_HOST}/_api/frontend/{REQUEST_URL}/.grid')
    if response.status_code != 200:
        raise RuntimeError(f'{response.status_code}: {response.content}')
    return response.json()['data']


def post_wiki_accesslevels(data: dict) -> dict:
    wiki_session = requests.Session()
    wiki_session.headers.update({'Authorization': f'OAuth {OAUTH_TOKEN}',
                                 'Content-Type': 'application/json'})
    response = wiki_session.post(
        url=f'https://{URL_HOST}/_api/frontend/{REQUEST_URL}/.grid/change',
        data=json.dumps(data)
    )
    if response.status_code != 200:
        raise RuntimeError(f'{response.status_code}: {response.content}')
    return response.json()


def main() -> None:
    all_access_levels = get_accesslevels_from_lenel('lenrus')
    wiki_grid = get_wiki_accesslevels()
    to_change = {'version': wiki_grid['version'], 'changes': []}
    count_of_change = 0
    workflow_string = []
    list_num = []
    IDM_COL = 2
    rgx = re.compile(r'([0-9]+)')
    for count in range(len(wiki_grid['rows'])):
        u_num = wiki_grid['rows'][count][IDM_COL]['raw']
        res = rgx.search(u_num)
        if res:
            res = int(res.group(1))
        else:
            res = -1
        init_position = u_num.find('lenel/levels/')
        if init_position < 0:
            continue
        num = int(u_num[init_position+13:u_num.find('(fields:()')])
        if res != num:
            logging.error('level mismach: %i(%s)', num, res)
        list_num.append(num)
        row_id = wiki_grid['rows'][count][IDM_COL]['row_id']

        url = 'https://idm.yandex-team.ru/#rf-role=XhVdqvlX#lenel/levels/'\
              f'{num}(fields:()),rf-expanded=XhVdqvlX,rf=1'
        new_text = ''.join(['[[', url, ' Запросить IDM]]'])
        if new_text != u_num:
            cols_name = wiki_grid['rows'][count][IDM_COL]['__key__']
            to_change['changes'].append({'edited_row': {'id': row_id, 'data': {cols_name: new_text}}})
            count_of_change += 1
            logging.info('IDM: %s:%s -> (%s)', row_id, cols_name, u_num)

        '''new_text = wiki_grid['rows'][count][1]['raw'] or []
        if wiki_grid['rows'][count][2]['raw']:
            wiki_grid['rows'][count][2]['raw'].sort()
            new_text.extend(wiki_grid['rows'][count][2]['raw'])
        if new_text != wiki_grid['rows'][count][6]['raw']:
            cols_name = wiki_grid['rows'][count][6]['__key__']
            to_change['changes'].append({'edited_row': {'id': row_id, 'data': {cols_name: new_text}}})
            count_of_change += 1
            logging.info('STAFF: row:col -> %s:%s', row_id, cols_name)'''

        '''new_text = wiki_grid['rows'][count][4]['raw']
        init_position = new_text.find('team.ru/')
        if init_position > 0:
            new_text = new_text[init_position+8:]
        init_position = new_text.find('?')
        if init_position > 0:
            new_text = new_text[:init_position]
        if new_text != wiki_grid['rows'][count][5]['raw']:
            cols_name = wiki_grid['rows'][count][5]['__key__']
            to_change['changes'].append({'edited_row': {'id': row_id, 'data': {cols_name: new_text}}})
            count_of_change += 1
            logging.info('Ticket: row:col -> %s:%s', row_id, cols_name)'''

        if num not in all_access_levels:
            logging.error('In only wiki exist: %i (%s)', num, wiki_grid['rows'][count][0]['raw'])
            continue
        new_text = ', '.join(sorted(all_access_levels[num]['rooms']))
        new_text = ''.join(['<{', all_access_levels[num]['name'], chr(10), '""', new_text, '""}>'])
        if new_text != wiki_grid['rows'][count][0]['raw']:
            if num in EXCLUDE_LEVELS:
                logging.info('Exculing level: %i (%s)', num, all_access_levels[num]['name'])
            else:
                cols_name = wiki_grid['rows'][count][0]['__key__']
                to_change['changes'].append({'edited_row': {'id': row_id, 'data': {cols_name: new_text}}})
                count_of_change += 1
                logging.info('NAME: %s:%s -> (%s)', row_id, cols_name, wiki_grid['rows'][count][0]['raw'])
        if count_of_change > 27:
            logging.info('Max posible changes limit %i', count_of_change)
            break
        workflow_string.append(gen_workflow(
            count, num, all_access_levels[num]['name'], wiki_grid['rows'][count][1]['raw']
        ))
    if len(to_change['changes']) == 0:
        set_num = set(list_num)
        not_in_wiki = set(all_access_levels) - set_num
        for item in not_in_wiki:
            logging.info('Absent at wiki: %s (%s)', item, all_access_levels[item]['name'])
        dubles = len(list_num) - len(set_num)
        if dubles != 0:
            for item in set_num:
                list_num.remove(item)
            for item in list_num:
                logging.info('Doubles: %s (%s)', item, all_access_levels[item]['name'])
        logging.info('Nothing to DO')
    else:
        post_wiki_accesslevels(to_change)
    workflow_string.append(f"else:{chr(10)}    approvers = ['shornin']{chr(10)}")
    logging.info(chr(10).join(workflow_string))
    return None


def gen_workflow(count: int, num: int, level_name: str, approvers: str) -> str:
    if count == 0:
        result_str = f"{chr(10)}if role['levels'] == '"
    else:
        result_str = "elif role['levels'] == '"
    return f"{result_str}{num}':  # {level_name}{chr(10)}"\
           f"    approvers = [any_from({approvers}, priority=1)]"


if __name__ == '__main__':
    prepare_for_logging(LOG_FILE, LOG_FILE_TO_SEND)
    main()
    body_message = 'Файлы приложены как вложения к данному письму. '\
        'Письмо было сгенерировано роботом, пожалуйста, не отвечайте на него.<br><br>'
    send_email(MAIL_TO, 'Выгрузка для WIKI Согласующие', body_message, [LOG_FILE_TO_SEND])
    logging.info('----------------------')
