import os
import time
import datetime
import logging
import argparse
from suds.client import Client, suds
import base64
import get_api_staff
from file_import_utils import (
    get_secret_from_yav,
    send_email,
    get_photo_bytes,
    prepare_for_logging,
    get_log_statictic,
    get_allbadge_from_lenel,
)

YAV_TOKEN = os.getenv('YAV_TOKEN', '')
WSDL_URL = 'http://lenrus-tmx.ld.yandex.ru:59361'
WSDL = f'{WSDL_URL}/Timex/TimexSDKService/?singlewsdl'
USER_WSDL = 'staff_integration'
PASSWORD_WSDL = get_secret_from_yav('sec-01fs4pxbgpbsjes5gbmrybc44p', USER_WSDL, YAV_TOKEN)
LOG_FILE = f'{os.path.splitext(__file__)[0]}.log'
LOG_FILE_TO_SEND = 'timex_result.txt'
MAIL_TO = ['diff_another@yandex-team.ru']
# https://staff-api.yandex-team.ru/v3/offices?_pretty=1&_fields=id,name,code&_limit=500
STAFF_TIMEX_COMPANY = {
    # id: [Company, Accesslevel, WorkingArea, CompanyName],
    # 503: ['VgBDAFUAagA=', '', '', 'ФФЦ Екатеринбург'],
    220: ['UABFAA==', 'UABAAA==', 'UABFAA==', 'ФФЦ Софьино'],
    642: ['VgBDAFUAbAA=', 'UABFAA==', 'UgBLAA==', 'СЦ Дзержинский'],
    807: ['VgBDAFUAbwA=', 'UgBEAA==', 'UgBAAA==', 'ФФЦ Софьино Возвраты'],
    808: ['VgBDAFQAZgA=', 'UgBLAA==', 'UgBHAA==', 'ФФЦ Софьино КГТ'],
    584: ['WABDAFYA', 'UwBFAA==', 'UwBAAA==', 'ФФЦ Санкт-Петербург'],
    213: ['UABEAA==', 'UABBAA==', 'UwBBAA==', 'ФФЦ Томилино'],
    210: ['UAA=', 'UAA=', 'UAA=', 'ФФЦ Ростов на Дону'],
    633: ['VgBDAFcAagA=', 'UABLAA==', 'UgBCAA==', 'СЦ Нижний Новгород'],
    629: ['VgBDAFcAaQA=', 'UwBDAA==', 'UAA=', 'СЦ Ростов на Дону'],
    617: ['VgBDAFcAaAA=', 'UwBHAA==', 'UwBFAA==', 'ФФЦ Самара'],
    509: ['VgBDAFQAaAA=', 'VQBDAA==', 'UgBEAA==', 'СЦ Чертаново'],
    622: ['VgBDAFcAZwA=', 'UwBAAA==', 'UwBEAA==', 'ФФЦ Новосибирск'],
    811: ['VgBDAFIAbAA=', 'UABKAA==', 'UwBEAA==', 'СЦ Новосибирск'],
    -1: ['VgBDAFIAZwA=', 'VQBHAA==', 'VQBBAA==', 'Яндекс СТАФФ'],
    # 000: ['WQA=', 'Яндекс'],
}

COUNT_LOAD = 200
ALL_COMPANIES = {}
ALL_WORKINGAREAS = {}
ALL_ACCESSLEVELS = {}


def get_company(session_id: str, oid_company: str):
    global ALL_COMPANIES
    if oid_company in ALL_COMPANIES:
        return ALL_COMPANIES[oid_company]
    else:
        filter_str = "Name like '%СТАФФ'"
        is_found = False
        companies = client.service.GetPackCompanies(session_id, 0, 0, filter_str)
        for company in companies[0]:
            ALL_COMPANIES[company.Oid] = company
            if company.Oid == oid_company:
                is_found = True
                found_company = company
        if is_found:
            return found_company
    logging.error(f'ERROR: company not found {oid_company}')
    return suds.null()


def get_workingareas(session_id: str, oid_area: str):
    global ALL_WORKINGAREAS
    if oid_area in ALL_WORKINGAREAS:
        return ALL_WORKINGAREAS[oid_area]
    else:
        filter_str = None
        is_found = False
        working_areas = client.service.GetPackWorkingAreas(session_id, 0, 0, filter_str)
        for area in working_areas['WorkingArea']:
            ALL_WORKINGAREAS[oid_area] = area
            if area.Oid == oid_area:
                is_found = True
                found_area = area
        if is_found:
            return found_area
    logging.error(f'ERROR: working_area not found {oid_area}')
    return suds.null()


def get_accesslevel_oid(session_id: str, oid_accesslevel: str):
    global ALL_ACCESSLEVELS
    if oid_accesslevel in ALL_ACCESSLEVELS:
        return ALL_ACCESSLEVELS[oid_accesslevel]
    else:
        is_found = False
        accesslevels = client.service.GetPackAccessLevels(session_id, 0, 0)
        for accesslevel in accesslevels[0]:
            ALL_ACCESSLEVELS[oid_accesslevel] = accesslevel.Oid
            if accesslevel.Oid == oid_accesslevel:
                is_found = True
                found_accesslevel = accesslevel.Oid
        if is_found:
            return found_accesslevel
    return suds.null()


def get_photo_and_crop(session_id: str, oid: str, identifier_group_id: str, file_name: str) -> None:
    binary_data = get_photo_bytes('photo', file_name)
    if not binary_data:
        logging.error(f'No photo: {file_name}')
        return None
    base64_message = base64.b64encode(binary_data).decode('utf-8')
    ids = {'string': [oid]}
    array_of_photos = {'base64Binary': [base64_message]}
    client.service.SetPhotosToEmployees(session_id, ids, array_of_photos, False)
    client.service.CopyAndCropMainEmployeePhotoToFaceGeometryTemplate(session_id, identifier_group_id)
    return None


def get_all_employees(session_id: str, filter_str: str = None) -> dict:
    timex_staff = {}
    count = 0
    while True:
        try:
            employees = client.service.GetPackEmployees(
                    session_id,
                    COUNT_LOAD,
                    int(COUNT_LOAD*count),
                    filter_str)['Employee']
        except TypeError:
            break
        for employee in employees:
            if employee.MidName in timex_staff:
                logging.warning(f'Allready exist key: {employee.MidName}')
            timex_staff[employee.MidName] = (
                0,  # id_badge
                employee.Name,
                employee.LastName,
                employee.Oid,
                employee.Company.Name if employee.Company else None,
                employee.Company.Oid if employee.Company else None,
                employee.DismissalDate,
            )
        count += 1
    logging.debug('%i запросов в TimexSDKService сделано', count)
    return timex_staff


def get_employees(session_id: str, id_string: str):
    ids = {'string': [id_string]}
    return client.service.GetEmployees(session_id, ids)


def update_employee(session_id: str,
                    employees,
                    login: str = None,
                    f_name: str = None,
                    l_name: str = None,
                    location: str = None,
                    id_badges: str = '0') -> None:
    if location is not None:
        employees['Employee'][0].Company = get_company(session_id, STAFF_TIMEX_COMPANY[location][0])
    if login is not None:
        employees['Employee'][0].MidName = login
    if f_name is not None:
        employees['Employee'][0].Name = f_name
    if l_name is not None:
        employees['Employee'][0].LastName = l_name
    ''' if id_badges.isdigit():
    ids = {'string': [employees['Employee'][0].Oid]}
    employees_detail = client.service.GetEmployeeDetailInfo(session_id, ids)

    ids_group = {'string': [employees_detail['EmployeeDetailInfo'][0].IdentifierGroups['IdentifierGroup'][0].Oid]}
    identifier_groups = client.service.GetIdentifierGroups(session_id, ids_group)
    identifier_groups['IdentifierGroup'][0].CardNumber = None  # or int(id_badges)
    identifier_groups['IdentifierGroup'][0].CardValidEndDate = None
    identifier_groups['IdentifierGroup'][0].CardValidStartDate = '2021-11-09 15:58:10.263000'
    client.service.UpdateIdentifierGroups(session_id, identifier_groups)
    '''
    if location > 0:
        employees['Employee'][0].AccessArea = get_workingareas(session_id, STAFF_TIMEX_COMPANY[location][2])
    client.service.UpdateEmployees(session_id, employees)
    return None


def remove_all_employees(session_id: str, employee_logins: set,
                         staff_emp: dict, timex_emp: dict) -> None:
    for login in employee_logins:
        logging.info(f'RemoveEmployees: {login}, {timex_emp[login]}')
        client.service.RemoveEmployees(session_id, {'string': [timex_emp[login][3]]})
    return None


def update_all_employees(session_id: str, employee_logins: set, staff_emp: dict, timex_emp: dict) -> None:
    for login in employee_logins:
        if staff_emp[login][3] == '':
            staff_emp[login][3] = '0'
        if staff_emp[login][0] != timex_emp[login][1] or \
                staff_emp[login][1] != timex_emp[login][2] or \
                STAFF_TIMEX_COMPANY[staff_emp[login][2]][0] != timex_emp[login][5]:
            logging.info(f'UpdateEmployees: {login}, {timex_emp[login]}, {staff_emp[login]}')
            employees = get_employees(session_id, timex_emp[login][3])
            update_employee(session_id, employees, login,
                            staff_emp[login][0],
                            staff_emp[login][1],
                            staff_emp[login][2],
                            staff_emp[login][3])
    return None


def create_all_employees(session_id: str, employee_logins: set, staff_emp: dict):
    for login in employee_logins:
        employees = client.service.CreateEmployees(session_id, 1)
        update_employee(session_id, employees,
                        login, staff_emp[login][0],
                        staff_emp[login][1],
                        staff_emp[login][2],
                        staff_emp[login][3])
        ids = {'string': [employees['Employee'][0].Oid]}
        employees_detail = client.service.GetEmployeeDetailInfo(session_id, ids)
        id_group = employees_detail['EmployeeDetailInfo'][0].IdentifierGroups['IdentifierGroup'][0].Oid
        client.service.SetAccessLevels(
            session_id,
            id_group,
            {'string': [get_accesslevel_oid(session_id, STAFF_TIMEX_COMPANY[staff_emp[login][2]][1])]}
        )
        try:
            get_photo_and_crop(session_id, employees['Employee'][0].Oid, id_group, login)
        except suds.WebFault:
            logging.error(f'ERROR: Очень плохое фото: {login}')
        logging.info(f'Adding: {login} ({STAFF_TIMEX_COMPANY[staff_emp[login][2]][3]})')
    return None


def get_update_vehicles(session_id: str) -> None:
    """TODO"""
    vehicles = client.service.GetPackVehicles(session_id, 2, 0)
    logging.info(vehicles)
    client.service.UpdateVehicles(session_id, {'Vehicle': vehicles})
    return None


def get_different(session_id: str, staff_emp: dict, timex_emp: dict) -> None:
    set_staff = set(staff_emp)
    set_timex = set(timex_emp)
    get_log_statictic(set_timex, set_staff)
    update_all_employees(session_id, set_timex & set_staff, staff_emp, timex_emp)
    create_all_employees(session_id, set_staff - set_timex, staff_emp)
    remove_all_employees(session_id, set_timex - set_staff, staff_emp, timex_emp)
    return None


def syncronoze_all_panels(session_id: str) -> None:
    list_of_oid = [x.Oid for x in client.service.GetPackSystems(
        session_id,
        0, 0,
        'Type == \'AccessControlPanel\'')[0]
    ]
    client.service.CreateExternalSystemsOperation(
        session_id,
        client.service.GetPackOperationsTypes(
            session_id,
            0, 0,
            'Type == \'SynchronizeConfiguration\''
        )[0][0],
        {'string': list_of_oid}
    )
    return None


def main_get_id():
    count = 0
    while True:
        count += 1
        try:
            session_id = client.service.LogonUser(USER_WSDL, PASSWORD_WSDL)
            break
        except suds.WebFault as error:
            logging.error(f'{count}: {error}')
            if count > 10:
                logging.error(f'ERROR: нет связи очень долго: {error}')
                raise error
            time.sleep(7*count+40)
    try:
        all_companies = client.service.GetPackCompanies(session_id, 0, 0)
        all_workingareas = client.service.GetPackWorkingAreas(session_id, 0, 0)
        all_accesslevels = client.service.GetPackAccessLevels(session_id, 0, 0)
    except suds.WebFault as error:
        logging.error(f'ERROR: {error}')
        raise error
    finally:
        client.service.LogoutUser(session_id)
    for item in all_companies[0]:
        logging.info('ALL_COMPANIES: %s (%s)', item.Name, item.Oid)
    for item in all_accesslevels[0]:
        logging.info('ALL_ACCESSLEVELS: %s (%s)', item.Name, item.Oid)
    for item in all_workingareas[0]:
        logging.info('ALL_WORKINGAREAS: %s (%s)', item.Name, item.Oid)
    return None


def get_market_persons() -> dict:
    result_employees = {}
    persons_filter = {
        '_fields': ','.join(['id', 'login', 'name', 'location.office.id']),
    }
    str_list = ','.join(str(x) for x in STAFF_TIMEX_COMPANY)
    persons_filter.update({'location.office.id': str_list})
    for login, api_data in get_api_staff.staff_api_persons(persons_filter).items():
        result_employees[login] = [
            api_data['name']['first']['ru'],
            api_data['name']['last']['ru'],
            api_data['location']['office']['id'],
            '',  # No of id_badges
            '',
        ]
    return result_employees


def get_yandex_persons() -> dict:
    result_employees = {}
    persons_filter = {'_fields': ','.join(['id', 'login', 'name'])}
    persons_filter.update({'official.staff_biometric_agreement': True,
                           'official.affiliation': 'yandex'})
    for login, api_data in get_api_staff.staff_api_persons(persons_filter).items():
        result_employees[login] = [
            api_data['name']['first']['ru'],
            api_data['name']['last']['ru'],
            -1,  # yandex_staff
            '',  # No of id_badges
            '',
        ]
    return result_employees


def main():
    count = 0
    while True:
        count += 1
        try:
            session_id = client.service.LogonUser(USER_WSDL, PASSWORD_WSDL)
            break
        except suds.WebFault as error:
            logging.error(f'{count}: {error}')
            if count > 10:
                logging.error(f'ERROR: нет связи очень долго: {error}')
                raise error
            time.sleep(7*count+40)
    staff_employees = get_market_persons()
    for login, data in get_yandex_persons().items():
        if login not in staff_employees:
            staff_employees[login] = data
    add_badge = get_allbadge_from_lenel('lenrus')
    logging.info(f'lenel => {len(add_badge)}')
    no_of_badge = set()
    for login in staff_employees:
        if login in add_badge:
            for key in add_badge[login]:
                if key not in staff_employees[login][3] and int(key) > 34000:
                    staff_employees[login][3] = key
        else:
            no_of_badge.add(login)
    filter_str = "Company.Name like '%СТАФФ'"
    try:
        timex_employees = get_all_employees(session_id, filter_str)
        get_different(session_id, staff_employees, timex_employees)
        syncronoze_all_panels(session_id)
    except suds.WebFault as error:
        logging.error(f'ERROR: {error}')
        raise error
    finally:
        client.service.LogoutUser(session_id)
    return None


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Process....')
    parser.add_argument('-get_id', action='store_true')
    args = parser.parse_args()

    logging.addLevelName(logging.CRITICAL + 1, "DISABLELOGGING")
    logging.DISABLELOGGING = logging.CRITICAL + 1
    log_level = logging.DISABLELOGGING

    prepare_for_logging(LOG_FILE, LOG_FILE_TO_SEND)
    date_s = datetime.datetime.now()
    logging.info('TIMEX-STAFF')
    try_count: int = 0
    while try_count < 10:
        try_count += 1
        try:
            client = Client(WSDL)
            client.set_options(proxy={'http': WSDL_URL})
            break
        except TimeoutError as e:
            logging.error(f'TimeoutError: {try_count}, {e}')
            time.sleep(10)
    if args.get_id:
        main_get_id()
    else:
        main()
        logging.info(f'Затрачено всего: {datetime.datetime.now()-date_s}')
        body_message = 'Файлы приложены как вложения к данному письму. '\
            'Письмо было сгенерировано роботом, пожалуйста, не отвечайте на него.<br><br>'
        send_email(MAIL_TO, 'Выгрузка для Timex', body_message, [LOG_FILE_TO_SEND])
    logging.info('----------------------')
