import logging

from django.http import HttpRequest, HttpResponse
from django.shortcuts import render
from django.urls import reverse
from ninja import NinjaAPI
from ninja.openapi import urls

from intranet.paste.src.api_v1.default_exception_handlers import subscribe_default_exception_handlers
from intranet.paste.src.api_v1.pastes.router import pastes_router

logger = logging.getLogger(__name__)


def swagger_redoc(request: HttpRequest, api: 'NinjaAPI') -> HttpResponse:
    context = {
        'api': api,
        'openapi_json_url': reverse(f'{api.urls_namespace}:openapi-json'),
    }

    return render(request, 'ninja/redoc.html', context)


# манки-патчим вьюшку, с Аркадией переопределение шаблонов не работает
urls.swagger = swagger_redoc

ninja_api = NinjaAPI(title='Paste', version='1.0.0', urls_namespace='apiv1:api')

ninja_api.add_router('', pastes_router)

subscribe_default_exception_handlers(ninja_api)
