from intranet.paste.src.api_v1.router_factory import make_user_api_router
from intranet.paste.src.api_v1.schemas import DELETED_RESPONSE, StatusOk, Collection
from intranet.paste.src.api_v1.pastes.views import (
    get_paste_view,
    create_paste_view,
    delete_paste_view,
    list_my_pastes_view,
)
from intranet.paste.src.api_v1.pastes.diagnostic_views import smoke_view
from intranet.paste.src.api_v1.pastes.schemas import PasteSchema

pastes_router = make_user_api_router()

pastes_router.get('/diag', response=StatusOk, include_in_schema=False)(smoke_view)

pastes_router.post('/pastes', response=PasteSchema)(create_paste_view)
pastes_router.get('/pastes/{uuid:uuid}', response=PasteSchema)(get_paste_view)
pastes_router.delete('/pastes/{uuid:uuid}', response=DELETED_RESPONSE)(delete_paste_view)

pastes_router.get('/me/pastes', response=Collection[PasteSchema])(list_my_pastes_view)
