from datetime import datetime
from typing import Optional

from ninja import Schema

from intranet.paste.src.coreapp.consts import Syntax
from intranet.paste.src.coreapp.models import Code


class CreatePasteRequest(Schema):
    syntax: Syntax
    text: str


LIMIT = 256
STUB_UUID = '00000000-0000-0000-0000-000000000000'


class PasteSchema(Schema):
    uuid: Optional[str]
    syntax: Syntax
    text: str
    created_at: datetime
    updated_at: datetime

    @classmethod
    def serialize_trimmed(cls, orm_model: Code) -> 'PasteSchema':
        return cls.serialize(orm_model, True)

    @classmethod
    def serialize(cls, orm_model: Code, trim: bool = False) -> 'PasteSchema':
        text = orm_model.text

        if trim and len(text) > 256:
            text = text[:256] + '...'

        return PasteSchema(
            uuid=str(orm_model.uuid) if orm_model.uuid else None,
            syntax=orm_model.syntax,
            text=text,
            created_at=orm_model.created_at,
            updated_at=orm_model.updated_at,
        )
