from django.shortcuts import get_object_or_404

from intranet.paste.src.api_v1.pastes.schemas import CreatePasteRequest, PasteSchema
from intranet.paste.src.api_v1.schemas import DELETED, PaginationQuery, Collection
from intranet.paste.src.coreapp.models import Code
from intranet.paste.src.api_v1.exceptions import Forbidden

from ninja import Query


def get_paste_view(request, uuid: str) -> PasteSchema:
    paste_data = get_object_or_404(Code, uuid=uuid, author=request.user, is_deleted=False)

    return PasteSchema.serialize(paste_data)


def create_paste_view(request, data: CreatePasteRequest) -> PasteSchema:
    paste_data = Code.objects.create(author=request.user, syntax=data.syntax)
    paste_data.text = data.text
    paste_data.is_compressed = True
    paste_data.assign_uuid_and_save()

    return PasteSchema.serialize(paste_data)


def delete_paste_view(request, uuid: str) -> DELETED:
    paste_data = get_object_or_404(Code, uuid=uuid, is_deleted=False)
    if paste_data.author_id != request.user.id:
        raise Forbidden()
    paste_data.is_deleted = True
    paste_data.save()

    return DELETED


def list_my_pastes_view(request, pagination: PaginationQuery = Query(...)) -> Collection[PasteSchema]:
    return Collection[PasteSchema].build(
        qs=Code.objects.filter(author=request.user, is_deleted=False).order_by('id'),
        pagination=pagination,
        serializer=PasteSchema.serialize_trimmed,
    )
