from django.contrib import admin

from .models import Code


class CodeAdmin(admin.ModelAdmin):
    list_display = ('id', 'author', 'syntax', 'updated_at', 'is_deleted')
    list_filter = ('syntax', 'is_deleted')
    search_fields = ('author__username',)
    readonly_fields = ('author', 'created_at', 'updated_at')
    ordering = ('-id',)


admin.site.register(Code, CodeAdmin)
