from enum import Enum


class Syntax(str, Enum):
    plain = 'plain'
    bash = 'bash'
    cpp = 'cpp'
    diff = 'diff'
    go = 'go'
    java = 'java'
    javascript = 'javascript'
    python = 'python'
    pytb = 'pytb'
    ipynb = 'ipynb'
    sql = 'sql'
    yql = 'yql'
    actionscript = 'actionscript'
    actionscript3 = 'actionscript3'
    ada = 'ada'
    applescript = 'applescript'
    c = 'c'
    c_sharp = 'c#'
    cmake = 'cmake'
    css = 'css'
    html_django = 'html+django'
    po = 'po'
    groovy = 'groovy'
    rust = 'rust'
    typescript = 'typescript'
    json = 'json'
    html = 'html'
    kotlin = 'kotlin'
    lighttpd = 'lighttpd'
    lua = 'lua'
    makefile = 'makefile'
    mysql = 'mysql'
    nginx = 'nginx'
    objectivec = 'objectivec'
    perl = 'perl'
    php = 'php'
    pycon = 'pycon'
    postgresql = 'postgresql'
    proto = 'proto'
    rconsole = 'rconsole'
    ruby = 'ruby'
    s = 's'
    scala = 'scala'
    swift = 'swift'
    html_tt2 = 'html+tt2'
    vim = 'vim'
    xml = 'xml'
    xslt = 'xslt'
    yaml = 'yaml'


SYNTAX_LABELS = {
    Syntax.plain: 'Plain text',
    Syntax.bash: 'Bash',
    Syntax.cpp: 'C++',
    Syntax.diff: 'Diff',
    Syntax.go: 'Golang',
    Syntax.java: 'Java',
    Syntax.javascript: 'JavaScript',
    Syntax.python: 'Python',
    Syntax.pytb: 'Python Traceback',
    Syntax.ipynb: 'IPython Notebook',
    Syntax.sql: 'SQL',
    Syntax.yql: 'YQL',
    Syntax.actionscript: 'ActionScript',
    Syntax.actionscript3: 'ActionScript 3',
    Syntax.ada: 'Ada',
    Syntax.applescript: 'AppleScript',
    Syntax.c: 'C',
    Syntax.c_sharp: 'C#',
    Syntax.cmake: 'CMake',
    Syntax.css: 'CSS',
    Syntax.html_django: 'Django HTML templates',
    Syntax.po: 'Gettext',
    Syntax.groovy: 'Groovy',
    Syntax.rust: 'Rust',
    Syntax.typescript: 'Typescript',
    Syntax.json: 'Json',
    Syntax.html: 'HTML',
    Syntax.kotlin: 'Kotlin',
    Syntax.lighttpd: 'Lighttpd config',
    Syntax.lua: 'Lua',
    Syntax.makefile: 'Makefile',
    Syntax.mysql: 'MySQL',
    Syntax.nginx: 'Nginx config',
    Syntax.objectivec: 'Objective-C',
    Syntax.perl: 'Perl',
    Syntax.php: 'PHP',
    Syntax.pycon: 'Python Console',
    Syntax.postgresql: 'PostgreSQL',
    Syntax.proto: 'Protobuf',
    Syntax.rconsole: 'R Console',
    Syntax.ruby: 'Ruby',
    Syntax.s: 'S',
    Syntax.scala: 'Scala',
    Syntax.swift: 'Swift',
    Syntax.html_tt2: 'Template Toolkit 2 HTML templates',
    Syntax.vim: 'Vim script',
    Syntax.xml: 'XML',
    Syntax.xslt: 'XSLT',
    Syntax.yaml: 'YAML',
}
