from django import forms
import nbformat

from .models import Code
from .utils.ant_secret import secrets_validator


class SyntaxSelect(forms.widgets.Select):
    def render_option(self, selected_choices, option_value, option_label):
        if option_value is None:
            sep = '-' * 30
            return '<option value="" disabled="disabled">%s</option>' % sep
        return super(SyntaxSelect, self).render_option(selected_choices, option_value, option_label)


class CodeForm(forms.ModelForm):

    syntax = forms.ChoiceField(choices=Code.SYNTAX_CHOICES, widget=SyntaxSelect)
    text = forms.CharField(validators=[secrets_validator], widget=forms.Textarea, strip=False)

    def clean(self):
        cleaned_data = super(CodeForm, self).clean()
        syntax = cleaned_data.get("syntax")

        if syntax == 'ipynb':
            text = cleaned_data.get("text")
            try:
                nbformat.reads(text, as_version=4)
            except Exception as e:
                self.add_error('text', str(e))

    class Meta:
        model = Code
        fields = ('syntax', 'text')
