from pygments.style import Style
from pygments.token import (
    Keyword,
    Name,
    Comment,
    String,
    Error,
    Text,
    Number,
    Operator,
    Generic,
    Whitespace,
    Punctuation,
    Literal,
)


WHITE = '#FFFFFF'
BLACK = '#000000'
YELLOW = '#FFCC00'
PURPLE = '#9E64A9'
BLUE = '#72C3E0'
GREEN = '#5BCD9D'
RED = '#FC6767'
GRAY = '#7F7F7F'


class YaDarkStyle(Style):

    default_style = ""

    background_color = BLACK

    styles = {
        Whitespace: BLACK,
        Comment: GRAY,
        Comment.Preproc: WHITE,
        Text: WHITE,
        Punctuation: WHITE,
        Keyword: YELLOW,
        Keyword.Pseudo: YELLOW,
        Keyword.Type: YELLOW,
        Operator: WHITE,
        Operator.Word: PURPLE,
        Name: WHITE,
        Name.Builtin: YELLOW,
        Name.Function: GREEN,
        Name.Class: GREEN,
        Name.Namespace: YELLOW,
        Name.Exception: WHITE,
        Name.Variable: WHITE,
        Name.Constant: WHITE,
        Name.Label: WHITE,
        Name.Entity: WHITE,
        Name.Attribute: WHITE,
        Name.Tag: YELLOW,
        Name.Decorator: PURPLE,
        Literal: WHITE,
        String: RED,
        String.Doc: RED,
        String.Interpol: RED,
        String.Escape: RED,
        String.Regex: RED,
        String.Symbol: RED,
        String.Other: RED,
        Number: RED,
        Generic.Heading: YELLOW,
        Generic.Subheading: YELLOW,
        Generic.Deleted: YELLOW,
        Generic.Inserted: YELLOW,
        Generic.Error: YELLOW,
        Generic.Emph: WHITE,
        Generic.Strong: YELLOW,
        Generic.Prompt: YELLOW,
        Generic.Output: YELLOW,
        Generic.Traceback: YELLOW,
        Error: RED,
    }
