from pygments.style import Style
from pygments.token import (
    Keyword,
    Name,
    Comment,
    String,
    Number,
)

BLACK = '#000000'
WHITE = '#FFFFFF'
RED = '#FF0000'
BLUE = '#3878BE'
PURPLE = '#9E64A9'
ORANGE = '#FE8C00'
GRAY = '#7F7F7F'


class YaLightStyle(Style):
    default_style = ""

    background_color = WHITE

    styles = {
        Comment: GRAY,
        Keyword: 'bold ' + BLUE,
        Name.Function: ORANGE,
        Name.Decorator: BLUE,
        Name.Class: PURPLE,
        Number: BLUE,
        String: RED,
    }
