from django.urls import path, re_path

from . import views

urlpatterns = [
    path('', views.index, name='index'),
    re_path(r'^(?P<pk>\d+)/?$', views.code, name='code'),
    re_path(r'^(?P<pk>\d+)/html/?$', views.html, name='code_html'),
    re_path(r'^(?P<pk>\d+)/text/?$', views.text, name='code_text'),
    re_path(r'^(?P<pk>\d+)/delete/?$', views.delete, name='code_delete'),
    re_path(r'^last/?$', views.last_code, name='last_code'),
    path('favicon.ico', views.ok_200, name='favicon'),
    path('<uuid:uuid>', views.code, name='code_uuid'),
    path('<uuid:uuid>/html', views.html, name='code_html_uuid'),
    path('<uuid:uuid>/text', views.text, name='code_text_uuid'),
    path('<uuid:uuid>/delete', views.delete, name='code_delete_uuid'),
    re_path(r'^(?P<username>[\w_-]+)/?$', views.user_code, name='user_code'),
]
