import requests
import logging
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry
from django.conf import settings
from django.forms import ValidationError

from intranet.paste.src.utils.tvm2 import get_service_ticket


logger = logging.getLogger(__name__)


def secrets_validator(text):
    if not settings.ANT_SECRET_ENABLED:
        return

    secrets = search_secrets(text)
    if secrets:
        raise ValidationError([format_secret(s) for s in secrets])


def search_secrets(text):
    try:
        headers = {'X-Ya-Service-Ticket': get_service_ticket(settings.ANT_SECRET_TVM2_ID)}
        if getattr(text, 'encode', None):
            text = text.encode('utf-8')

        response = session.post(
            settings.ANT_SECRET_API_URL, data=text, headers=headers, timeout=settings.ANT_SECRET_TIMEOUT
        )
        response.raise_for_status()
        return response.json()
    except Exception as e:
        logger.exception('failed to call ant-secret: %s', e)
    return []


def format_secret(secret):
    info = ''
    if 'info' in secret:
        info = '(%s)' % secret['info']
    return 'Found secret at line %d: %s %s' % (secret['line'], secret['type'], info)


def requests_retry_session(retries=2, backoff_factor=0.3, session=None):
    session = session or requests.Session()
    retry = Retry(
        total=retries,
        read=retries,
        connect=retries,
        backoff_factor=backoff_factor,
        method_whitelist=False,  # retry on any method
    )
    # hack
    retry.RETRY_AFTER_STATUS_CODES = frozenset([413, 429, 503, 502])
    adapter = HTTPAdapter(max_retries=retry)
    session.mount('http://', adapter)
    session.mount('https://', adapter)
    return session


session = requests_retry_session()
