from django.http import HttpResponse

from intranet.paste.src.coreapp.models import Code

from django_replicated.utils import routers
from django_replicated.dbchecker import db_is_alive


def databases_for_reading_left():
    """
    Возвращает False, если не осталось базы из которой можно читать.
    """
    db_instance_name = routers.db_for_read(Code)
    if db_instance_name == routers.DEFAULT_DB_ALIAS:
        # django_replicated не проверяет мастер на живость в db_for_read
        if not db_is_alive(db_instance_name, number_of_tries=3):
            return False
    return True


def ping(request):
    message = 'I\'m alive'
    status = 200
    # check MySQL availability
    if not databases_for_reading_left():
        status = 500
        message = 'Can\'t connect to MySQL'

    return HttpResponse(message, status=status, content_type='text/plain')
