import os
from django_replicated.settings import *  # noqa
from django_pgaas import HostManager

from .typed_settings import TYPED_SETTINGS
from .utils import replace_on_unittest

YANDEX_ROOT_CERTIFICATE = '/etc/ssl/certs/ca-certificates.crt'
DATABASE_ENGINE = 'django_pgaas.backend'
host_manager = HostManager(TYPED_SETTINGS.db.hosts, current_dc=os.getenv('DEPLOY_NODE_DC'))

MDB = {
    'default': {
        'ENGINE': DATABASE_ENGINE,
        'NAME': TYPED_SETTINGS.db.name,
        'USER': TYPED_SETTINGS.db.user,
        'PASSWORD': TYPED_SETTINGS.db.password,
        'HOST': host_manager.host_string,
        'PORT': TYPED_SETTINGS.db.port,
        'CONN_MAX_AGE': 600,  # in sec
        'OPTIONS': {
            'target_session_attrs': 'read-write',
            'sslmode': 'verify-full',
            'connect_timeout': 2,
            'sslrootcert': YANDEX_ROOT_CERTIFICATE,
        },
    },
    'slave': {
        'ENGINE': DATABASE_ENGINE,
        'NAME': TYPED_SETTINGS.db.name,
        'USER': TYPED_SETTINGS.db.user,
        'PASSWORD': TYPED_SETTINGS.db.password,
        'HOST': host_manager.host_string,
        'PORT': TYPED_SETTINGS.db.port,
        'CONN_MAX_AGE': 600,  # in sec
        'OPTIONS': {
            'target_session_attrs': 'any',
            'sslmode': 'verify-full',
            'connect_timeout': 5,
            'sslrootcert': YANDEX_ROOT_CERTIFICATE,
        },
    },
}

UNITTEST_DB = {
    'default': {
        'ENGINE': 'django_pgaas.backend',
        'HOST': 'localhost',
        'NAME': os.environ.get('PG_LOCAL_DATABASE', 'postgres'),
        'USER': os.environ.get('PG_LOCAL_USER', 'postgres'),
        'PORT': os.environ.get('PG_LOCAL_PORT', '5433'),
        'PASSWORD': os.environ.get('PG_LOCAL_PASSWORD', 'postgres'),
    }
}

DATABASES = replace_on_unittest(MDB, UNITTEST_DB)
REPLICATED_DATABASE_SLAVES = replace_on_unittest(['slave'], [])

DATABASE_ROUTERS = ['django_replicated.router.ReplicationRouter']

REPLICATED_CHECK_STATE_ON_WRITE = False
