import os

from .typed_settings import TYPED_SETTINGS
from .utils import replace_on_unittest

PROJECT_ROOT = os.path.dirname(os.path.abspath(__file__))

DEBUG = TYPED_SETTINGS.debug

ADMINS = [
    ('Neo Felis', 'neofelis@yandex-team.ru'),
    ('Dmitry Terrov', 'terrmit@yandex-team.ru'),
    ('Vladimir Koljasinskij', 'smosker@yandex-team.ru'),
]

MANAGERS = ADMINS

PASTE_HOST = TYPED_SETTINGS.hostname

SITE_ID = 1

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True

LANGUAGE_CODE = 'ru'

ROOT_URLCONF = 'intranet.paste.src.urls'

SECRET_KEY = TYPED_SETTINGS.secret

INSTALLED_APPS = (
    'django_yauth',
    'django.contrib.auth',
    'django.contrib.admin',
    'django.contrib.contenttypes',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.humanize',
    'django_template_common',
    'waffle',
    'intranet.paste.src',
    'intranet.paste.src.coreapp',
    'intranet.paste.src.ping',
    'intranet.paste.src.api_v1',
)

MIDDLEWARE = (
    'intranet.paste.src.middleware.PingMiddleware',
    'intranet.paste.src.utils.collablogger.CollabLoggerMiddleware',
    'intranet.paste.src.utils.compat.DjangoStubAuthMiddleware',
    'intranet.paste.src.middleware.BanMiddleware',
    'django_replicated.middleware.ReplicationMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    replace_on_unittest(
        'django_yauth.middleware.YandexAuthMiddleware', 'intranet.paste.src.test_utils.TestAuthMiddleware'
    ),
    'intranet.paste.src.middleware.ReadOnlyMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
)

MEDIA_ROOT = ''
MEDIA_URL = ''

STATIC_URL = '/static/'
STATIC_ROOT = '/static'

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder',
]

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': False,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.i18n',
                'django.contrib.messages.context_processors.messages',
                'django_yauth.context.yauth',
            ],
        },
    }
]

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
        'LOCATION': 'default',
        'TIMEOUT': 300,
        'OPTIONS': {
            'MAX_ENTRIES': 1000,
        },
    },
}

allowed_hosts_set = set(TYPED_SETTINGS.allowed_hosts)
allowed_hosts_set.add(TYPED_SETTINGS.hostname)

ALLOWED_HOSTS = list(allowed_hosts_set)

FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'
