import sys

from .typed_settings import TYPED_SETTINGS

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'unittest': {
            'format': '%(levelname)-7s | %(message)s',
            '()': 'intranet.paste.src.utils.collablogger.ColoredContextFormatter',
        },
        'default': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'stream': sys.stdout,
            'formatter': 'unittest' if TYPED_SETTINGS.unittest else 'default',
        },
        'null': {
            'class': 'logging.NullHandler',
        },
    },
    'loggers': {
        'django.request': {
            'handlers': ['null'],
            'level': 'ERROR',
            'propagate': False,
        },
        # Мьютим спам "Cache was updated with public keys"
        'TVM': {
            'level': 'WARNING',
            'propagate': False,
            'handlers': ['null'],
        },
        'django': {
            'level': TYPED_SETTINGS.loglevel,
            'handlers': ['stream'],
            'propagate': True,
        },
        'requests': {
            'level': 'ERROR',
            'handlers': ['stream'],
            'propagate': True,
        },
        'collablogger': {
            'level': 'DEBUG',
            'handlers': ['stream'],
            'propagate': False,
        },
        'py.warnings': {
            'level': 'ERROR',
            'handlers': ['stream'],
            'propagate': True,
        },
    },
    'root': {
        'level': TYPED_SETTINGS.loglevel,
        'handlers': ['stream'],
    },
}
