from django_yauth.settings import *  # noqa
from django_yauth.settings import YAUTH_REAL_IP_HEADERS

from .typed_settings import TYPED_SETTINGS

YAUTH_TYPE = 'intranet'
CREATE_USER_ON_ACCESS = True
YAUSER_ADMIN_LOGIN = True
YAUTH_CREATION_REDIRECT = True

YAUTH_MECHANISMS = [
    'django_yauth.authentication_mechanisms.tvm',
    'django_yauth.authentication_mechanisms.cookie',
    'django_yauth.authentication_mechanisms.oauth',
]

YAUTH_TVM2_CLIENT_ID = TYPED_SETTINGS.tvm2.client_id
YAUTH_TVM2_SECRET = TYPED_SETTINGS.tvm2.secret
YAUTH_TVM2_ALLOWED_CLIENT_IDS = TYPED_SETTINGS.tvm2.allowed_clients

_hdr = 'HTTP_X_FORWARDED_FOR_Y'

if _hdr not in YAUTH_REAL_IP_HEADERS:
    OLD_YAUTH_REAL_IP_HEADERS = YAUTH_REAL_IP_HEADERS
    YAUTH_REAL_IP_HEADERS = ('HTTP_X_FORWARDED_FOR_Y',) + OLD_YAUTH_REAL_IP_HEADERS
