# flake8: noqa
"""
Тут импортируются все настройки из settings.py (в режимах development и local), и изменяется только то, что нужно.

1. Грузим .env для тестов
2. Грузим основные настройки
3. Патчим
"""
from io import StringIO
from library.python import resource
from dotenv import load_dotenv

dotenv = StringIO(resource.resfs_read('intranet/paste/src/dotenv').decode())
load_dotenv(stream=dotenv)

from intranet.paste.src.settings import *  # порядок импротов важен

if 'slave' in DATABASES:
    del DATABASES['slave']


class DisableMigrations(object):
    def __contains__(self, item):
        return True

    def __getitem__(self, item):
        return None


if not TYPED_SETTINGS.use_migrations_in_tests:
    MIGRATION_MODULES = DisableMigrations()
