import logging

from colorama import Fore, Style
from ylog.context import ContextFormatter


class ColoredContextFormatter(ContextFormatter):
    color_map = {
        logging.INFO: Style.RESET_ALL,
        logging.WARN: Fore.YELLOW,
        logging.DEBUG: Fore.WHITE,
        logging.ERROR: Fore.LIGHTRED_EX,
    }

    ctx_color = Fore.WHITE
    default_color = Fore.WHITE

    def serialized_log_context(self):
        if self.is_context_exist() and self.local_data.get_data():
            return ' | ' + self.serialize_context()
        return ''

    def format(self, record):
        result = logging.Formatter.format(self, record)
        ctx = self.serialized_log_context()
        color = self.color_map.get(record.levelno, self.default_color)
        return f'{color}{result}{self.ctx_color}{ctx}{Style.RESET_ALL}'
