from dataclasses import dataclass, field
from enum import Enum
from typing import Dict, List


class MaskType(Enum):
    PLAINTEXT = 0  # Заголовок
    MASKED = -1  # ***


DEFAULT_HEADERS = {
    'HTTP_REFERER': MaskType.PLAINTEXT,
    'HTTP_USER_AGENT': MaskType.PLAINTEXT,
}


@dataclass
class CollabLoggerConfig:
    headers: Dict[str, MaskType] = field(default_factory=lambda: DEFAULT_HEADERS)
    spammy_routes: List[str] = field(default_factory=list)  # всякие пинги, которые если они 200, мы их игнорим
    do_timeshaming: bool = True  # повышать критичность логов если запрос медленный
    slow_err_ms: int = 5000
    slow_warn_ms: int = 1000
