from enum import Enum
import waffle
import os


class Experiment(str, Enum):
    SECURE_ID = 'secure_ids'
    FORBID_LAST = 'forbid_last'
    FORBID_HOMEPAGE = 'forbid_homepage'


def is_experiment(e: Experiment) -> bool:
    return waffle.switch_is_active(e.value)


def get_post_url():
    return os.environ.get('sib_post', 'https://clubs.at.yandex-team.ru/security/15522')
