from __future__ import absolute_import

from django.conf import settings

from tvm2 import TVM2


class TVM2Error(Exception):
    pass


def get_tvm2_client():
    return TVM2(
        client_id=settings.TVM2_CLIENT_ID,
        secret=settings.TVM2_SECRET,
        blackbox_client=settings.TVM2_BLACKBOX_CLIENT,
        destinations=settings.TVM2_DESTINATIONS,
    )


def get_service_ticket(client_id):
    tvm2_client = get_tvm2_client()

    service_tickets = tvm2_client.get_service_tickets(client_id)
    service_ticket = service_tickets.get(client_id)
    if not service_ticket:
        raise TVM2Error('Can\'t get service ticket for client_id={}'.format(client_id))
    return service_ticket
