from django.contrib.auth.backends import ModelBackend

from rest_framework import authentication


class RequestUserAuthentication(authentication.BaseAuthentication):
    """Нужно, чтобы прокинуть пользователя, присвоенного через django_yauth, в DRF
    """
    def authenticate(self, request):
        return request._request.user, None


class AuthBackend(ModelBackend):
    """Мы не используем пермишены на auth.Group, переопределим, чтоб не делать лишних запросов"""

    def get_group_permissions(self, user_obj, obj=None):
        return []
