from typing import List
import urllib.parse

from django.conf import settings
from requests.exceptions import HTTPError

from plan.common.utils.http import Session
from plan.common.utils.tvm import get_tvm_ticket
from plan.resources.exceptions import SupplierError


def get_unclosable_services(service_ids) -> List[int]:
    url = urllib.parse.urljoin(settings.D_ENDPOINT, '/abc/_checkClosing')

    data = {
        'serviceIds': service_ids
    }

    headers = {
        'X-Ya-Service-Ticket': get_tvm_ticket(destination=str(settings.D_TVM_ID)),
    }

    with Session() as session:
        response = session.post(url, headers=headers, json=data)

    try:
        response.raise_for_status()
    except HTTPError as e:
        raise SupplierError(getattr(e, 'message', repr(e)))

    data = response.json()

    not_closable_services = [el['serviceId'] for el in data['closing'] if not el['value']]

    return not_closable_services
